/*
* See the file LICENSE for redistribution information.
*
* Copyright: 2010- 1stclass.co.jp.  All rights reserved.
*
* Created by Hajime Kurita
*/
#include <string>
#include <string.h>
#include <iostream>
#include <sys/stat.h>
#include "../1stclass.hpp"
#include "../1stclass.h"
using namespace std;

class tester{
public:
  tester(){ok=0;bad=0;};
  void test();
  void report();
private:
  int ok;
  int bad;
};

void tester::test(){
  firstclass fst;
  struct stat st;
// is_num:
// Judge whether this is number or not
// 数字かどうかの判別
  if(fst.is_num("2") && fst.is_num("test")==0){
    cout << "is_num/C++: ok "<< endl;
    ok++;
  }
  else{
    cout << "is_num/C++: bad" << endl;
    bad++;
  }

  if(is_num("2") && is_num("test")==0){
    cout << "is_num/C: ok "<< endl;
    ok++;
  }
  else{
    cout << "is_num/C: bad" << endl;
    bad++;
  }

// host2ip
// Get IP from host name
// ホスト名からIPを得る
  string server="www.yahoo.co.jp";
  string ip=fst.host2ip(server);
  if( (ip.at(0) - '1'>=0) && (ip.at(0) - '1'<=9) ){
    cout << "host2ip/C++: ok" << endl;
    ok++;
  }
  else{
    cout << "host2ip/C++: bad" << endl;
    bad++;
  }

  char c_server[]="www.yahoo.co.jp";
  char c_ip[32]="";
  host2ip(c_server, c_ip);
  if( (c_ip[0] - '1' >=0) && (c_ip[0] - '1' <=9) ){
    cout << "host2ip/C: ok" << endl;
    ok++;
  }
  else{
    cout << "host2ip/C: bad" << endl;
    bad++;
  }

// rel2abs:
// Get absolute path from relative path
// 相対パスから絶対パスを得る
  string rel_path="../lib1stclass/1/2/3";
  string abs_path=fst.rel2abs(rel_path);
  if( abs_path.find("/")==0 &&  abs_path.find("lib1stclass/1/2/3")!=string::npos){
    cout << "rel2abs/C++: ok" << endl;
    ok++;
  }
  else{
    cout << "rel2abs/C++: bad" << endl;
    bad++;
  }
  
  char rel_path_char[]="../lib1stclass/1/2/3";
  char abs_path_char[1024]="";
  rel2abs(rel_path_char, abs_path_char);
  if( abs_path_char[0]=='/' && strstr(abs_path_char, "lib1stclass/1/2/3")!=NULL){
    cout << "rel2abs/C: ok" << endl;
    ok++;
  }
  else{
    cout << "rel2abs/C: bad" << "/" << abs_path_char << endl;
    bad++;
  }

  string rel_path2="lib1stclass/1/2/3";
  string abs_path2=fst.rel2abs(rel_path2);
  if( abs_path2.find("/")==0 &&  abs_path2.find("/lib1stclass/1/2/3")!=string::npos){
    cout << "rel2abs/C++: ok" << endl;
    ok++;
  }
  else{
    cout << "rel2abs/C++: bad" << endl;
    bad++;
  }
  
  char rel_path_char2[]="lib1stclass/1/2/3";
  char abs_path_char2[1024]="";
  rel2abs(rel_path_char2, abs_path_char2);
  if( abs_path_char2[0]=='/' && strstr(abs_path_char2, "/lib1stclass/1/2/3")!=NULL){
    cout << "rel2abs 2/C: ok" << endl;
    ok++;
  }
  else{
    cout << "rel2abs 2/C: bad" << endl;
    bad++;
  }
  
  string rel_path3="/tmp/1/2/3";
  string abs_path3=fst.rel2abs(rel_path3);
  if( abs_path3=="/tmp/1/2/3"){
    cout << "rel2abs 3/C++: ok" << endl;
    ok++;
  }
  else{
    cout << "rel2abs 3/C++: bad" << endl;
    bad++;
  }
  
  char rel_path_char3[]="/tmp/1/2/3";
  char abs_path_char3[1024]="";
  rel2abs(rel_path_char3, abs_path_char3);
  if( strcmp(abs_path_char3, "/tmp/1/2/3")==0){
    cout << "rel2abs 3/C: ok" << endl;
    ok++;
  }
  else{
    cout << "rel2abs 3/C: bad" << endl;
    bad++;
  }

// rmkdir:
// mkdir recursively
// ディレクトリを再帰的に作る
  fst.rmkdir("test_dir/depth2");
  if(stat("test_dir/depth2", &st)==0){
    cout << "rmkdir/C++: ok" << endl;
    ok++;

// remove_path:
// Remove path completely
// パス全体を消去（ディレクトリを再帰的に消去）
    fst.remove_path("test_dir");
    if(stat("test_dir", &st)!=0){
      cout << "remove_path/C++: ok" << endl;
      ok++;
    }
    else{
      cout << "remove_path/C++: bad" << endl;
      bad++;
    }
  }
  else{
    cout << "rmkdir/C++: bad" << endl;
    bad++;
  }

  rmkdir("test_dir/depth_2");
  if(stat("test_dir/depth_2", &st)==0){
    cout << "rmkdir/C: ok" << endl;
    ok++;
    remove_path("test_dir");
    if(stat("test_dir", &st)!=0){
      cout << "remove_path/C: ok" << endl;
      ok++;
    }
    else{
      cout << "remove_path/C: bad" << endl;
      bad++;
    }
  }
  else{
    cout << "rmkdir/C: bad" << endl;
    bad++;
  }

// itoa
// Convert int to char
// int型をchar型に変換
  int integer=12345;
  char itoa_str[6]="";

  fst.itoa(integer, itoa_str);
  if (strcmp(itoa_str,"12345") == 0){
    cout << "itoa/C++: ok" << endl;
    ok++;
  }
  else{
    cout << "itoa/C++: bad" << endl;
    bad++;
  }

  itoa_str[0]='\0';
  itoa(integer, itoa_str);
  if (strcmp(itoa_str,"12345") == 0){
    cout << "itoa/C: ok" << endl;
    ok++;
  }
  else{
    cout << "itoa/C: bad" << endl;
    bad++;
  }

// reverse_char:
// Reverse char
// charを逆並びにする
  char example1[]="1234";
  fst.reverse_char(example1);
  if (strcmp(example1,"4321") == 0){
    cout << "reverse_char/C++: ok" << endl;
    ok++;
  }
  else{
    cout << "reverse_char/C++: bad" << endl;
    bad++;
  }
  
  char example2[]="1234";
  reverse_char(example2);
  if (strcmp(example2,"4321") == 0){
    cout << "reverse_char/C: ok" << endl;
    ok++;
  }
  else{
    cout << "reverse_char/C: bad" << endl;
    bad++;
  }

// remove_not_file_char:
// Convert ascii characters which cannot be used for file name into "_"
// ファイルシステムに使えないアスキー文字を「_」に変換
  string not_file_str="bk\\sl/sm:as*qt?dq\"lt<rt>vt|";
  string file_str=fst.remove_not_file_char(&not_file_str);
  if (file_str=="bk_sl_sm_as_qt_dq_lt_rt_vt_"){
    cout << "remove_not_file_char/C++: ok" << endl;
    ok++;
  }
  else{
    cout << "remove_not_file_char/C++: bad" << endl;
    bad++;
  }

  char not_file_char[]="bk\\sl/sm:as*qt?dq\"lt<rt>vt|";
  char file_char[1024]="";
  remove_not_file_char(not_file_char, file_char);
  if (strcmp(file_char,"bk_sl_sm_as_qt_dq_lt_rt_vt_")==0){
    cout << "remove_not_file_char/C: ok" << endl;
    ok++;
  }
  else{
    cout << "remove_not_file_char/C: bad" << endl;
    bad++;
  }

// shmf:
// Create temporary file on /dev/shm/
// /dev/shm/上への一時ファイル生成
  string file="/tmp/test.txt";
  if(fst.shmf(file)=="/dev/shm/_tmp_test.txt"){
    cout << "shmf/C++: ok" << endl;
    ok++;
  }
  else{
    cout << "shmf/C++: bad" << endl;
    bad++;
  }

  char tfile[]="/tmp/test.txt";
  char sfile[1024]="";
  shmf(tfile, sfile);
  if(strcmp(sfile, "/dev/shm/_tmp_test.txt")==0){
    cout << "shmf/C: ok" << endl;
    ok++;
  }
  else{
    cout << "shmf/C: bad" << endl;
    bad++;
  }

// safe_strcat:
// Safe strcat
// 安全なstrcat
  char a1[20]="";
  char b1[]="12345";
  fst.safe_strcat(a1, b1, sizeof(a1));
  if(strcmp(a1,b1)==0){
    cout << "safe_strcat 1/C++: ok" << endl;
    ok++;
  }
  else{
    cout << "safe_strcat 1/C++: bad" << endl;
    bad++;
  }
  
  char a2[20]="";
  char b2[]="12345";
  safe_strcat(a2, b2, sizeof(a2));
  if(strcmp(a2,b2)==0){
    cout << "safe_strcat 2/C: ok" << endl;
    ok++;
  }
  else{
    cout << "safe_strcat 2/C: bad" << endl;
    bad++;
  }
  
  char a3[2]="";
  char b3[]="12345";
  fst.safe_strcat(a3, b3, sizeof(a3));
  if(strcmp(a3,"1")==0){
    cout << "safe_strcat 3/C++: ok" << endl;
    ok++;
  }
  else{
    cout << "safe_strcat 3/C++: bad" << endl;
    bad++;
  }
  
  char a4[2]="";
  char b4[]="12345";
  safe_strcat(a4, b4, sizeof(a4));
  if(strcmp(a4,"1")==0){
    cout << "safe_strcat 4/C: ok" << endl;
    ok++;
  }
  else{
    cout << "safe_strcat 4/C: bad" << endl;
    bad++;
  }
}

void tester::report(){
  cout << "ok=" << ok << "\t" << "bad=" << bad << endl;
}

int main(){
  tester tester;
  tester.test();
  tester.report();
}
