/**
 *  @file   test_pack.c
 *  @brief  packライブラリのテストプログラム
 *
 *  テスト用データとして、char,short,long,float,doubleの変数と、それぞれの配列を用意し、それぞれ適当な値で初期化します。
 *  libpackを用いてsaveした後、別の変数にloadします。
 *  すべてを比較して、値がすべて同じであれば"OK", ひとつでも違う値があれば"NG"を表示して終了します。
 *
 */
#include <stdio.h>
#include "pack.h"

/* 配列のサイズ */
#define NUM 1000

int
main (int argc, char** argv)
{
    /* x:saveする変数　y:loadする変数 */
    char cvx = 'h';
    char cvy = 0;
    short hvx = 12345;
    short hvy = 0;
    long lvx = 1234567;
    long lvy = 0;
    float fvx = 3.1415;
    float fvy = 0.0;
    double dvx = 2.1731;
    double dvy = 0.0;
    char cax[NUM], cay[NUM];
    short hax[NUM], hay[NUM];
    long lax[NUM], lay[NUM];
    float fax[NUM], fay[NUM];
    double dax[NUM], day[NUM];

    char buff[20000];
    int size;
    int i;

    /* 配列変数の初期化 */
    for (i = 0; i < NUM; i++) {
        cax[i] = 'a' + i;
        hax[i] = -2* i + 1;
        lax[i] = -2* i + 1;
        fax[i] = -i * i;
        dax[i] = i * i;
    }

    /* サイズの確認 */
    size = pack_size ("c h l f d c# h# l# f# d#", NUM, NUM, NUM, NUM, NUM);
    printf ("size = %d\n", size);
    if (size > sizeof(buff)) {
        fprintf (stderr, "buffer size exceeded.\n");
        return 1;
    }
    /* packの保存 */
    pack_save (buff, "c h l f d c# h# l# f# d#", cvx, hvx, lvx, fvx, dvx, cax, NUM, hax, NUM, lax, NUM, fax, NUM, dax, NUM);

    /* packの復元 */
    pack_load (buff, "c h l f d c# h# l# f# d#", &cvy, &hvy, &lvy, &fvy, &dvy, cay, NUM, hay, NUM, lay, NUM, fay, NUM, day, NUM);

    /* 値の同一性をチェック */
    if (cvx != cvy || hvx != hvy || lvx != lvy || fvx != fvy || dvx != dvy) {
        fprintf (stderr, "value NG\n");
        return 1;
    }
    for (i = 0; i < NUM; i++) {
        if (cax[i] != cay[i] || hax[i] != hay[i] || lax[i] != lay[i] || fax[i] != fay[i] || dax[i] != day[i]) {
            fprintf (stderr, "array NG\n");
            return 1;
        }
    }
    /* 値がすべて等しい（成功） */
    fprintf (stderr, "OK\n");

    return 0;
}
