#pragma once
#include<list>
#include<typeinfo>
#include<WaveStream/Base/typedef.hpp>

namespace LibSynthPP {
   namespace Base {
      class IWaveStream;//プロトタイプ宣言
      //コントロールメッセージ
      class ControlMessage {
	 int32_t messageID;//メッセージID
	 IWaveStream *sender;//送信元
	 int64_t time;//受信予定時刻。
	 void *param;//パラメータ

	 //デフォルトコンストラクタの抑制。
	 ControlMessage() {}

      public:
	 //コンストラクタ
	 //Paramは自動で解放されない(他が責任を持って管理しなければならない。)
	 ControlMessage(int32_t MessageID,IWaveStream *Sender,int64_t Time,void *Param) {
	    this->messageID=MessageID;
	    this->sender=Sender;
	    this->time=Time;
	    this->param=Param;
	 }
	 int32_t getMessageID() const{
	    return messageID;
	 }
	 IWaveStream* getSender() const{
	    return sender;
	 }
	 int64_t getTime() const{
	    return time;
	 }
	 void* getParam() const{
	    return param;
	 }
	 //比較演算子
	 static bool compairTo(ControlMessage* a, ControlMessage* b){
	    return (a->time < b->time ? true:false);
	 }
      };
      //コントロールメッセージ管理クラス
      class ControlMessageManager {
	 std::list<ControlMessage*> msgList;
      public:
	 //コンストラクタ
	 ControlMessageManager() {
	 }
	 //デストラクタ
	 ~ControlMessageManager() {
	    //メッセージの削除
	    clear();
	 }
	 //メッセージのクリア
	 void clear(){
	    for (std::list<ControlMessage*>::iterator iter=msgList.begin();
		 iter!=msgList.end();++iter) {
	       delete (*iter);
	    }
	 }
	 //メッセージ追加
	 void addMessage(ControlMessage *msg) {
	    msgList.push_back(msg);
	 }
	 //メッセージ受信
	 // [∞,endtime)　の間のメッセージを受信
	 std::list<ControlMessage*>* getMessage(int64_t endTime) {
	    std::list<ControlMessage*>* ret=new std::list<ControlMessage*>();
	    //まずはソート
	    msgList.sort(ControlMessage::compairTo);
	    //すべて読み出すか、endTime以上の時間が出てきたら終了
	    for (std::list<ControlMessage*>::iterator iter=msgList.begin();
		 iter!=msgList.end() && (*iter)->getTime()<endTime;) {
	       ret->push_back(*iter);
	       msgList.erase(iter++);
	    }
	    //番兵追加
	    ret->push_back(new ControlMessage(0,NULL,endTime,NULL));
	    return ret;
	 }
      };
      //信号フォーマット。型や値域には触れない。
      class WaveFormat{
	 int32_t _frequency;
	 int32_t _channelNum;
	 //デフォルトコンストラクタ抑制
	 WaveFormat(){}
      public:
	 WaveFormat(int32_t frequency,int32_t channelNum){
	    this->_frequency=frequency;
	    this->_channelNum=channelNum;
	 }
	 int32_t getFrequency()const{
	    return _frequency;
	 }
	 int32_t getChannelNum()const{
	    return _channelNum;
	 }
	 bool operator==(WaveFormat &obj)const{
	    return this->_frequency==obj._frequency &&
	       this->_channelNum==obj._channelNum;
	 }
	 bool operator==(WaveFormat *obj)const{
	    return this->_frequency==obj->_frequency &&
	       this->_channelNum==obj->_channelNum;  
	 }
	 static WaveFormat* createNullWaveFormat(){
	    return new WaveFormat(0,0);
	 }
      };
   };
};
