#pragma once
//現在backtraceのためにglibc依存。
#include<stdexcept>
#include<string>
#include<sstream>

#define THROW(EXCEPTION_TYPE, message) \
   throw EXCEPTION_TYPE(message, __FILE__, __func__, __LINE__)
namespace LibSynthPP {
   namespace Base {
      //状態にあわない処理をしたときに発生。
      class Exception:public std::exception{
	 const char *message,*fileName,*functionName,*_msg;
	 int line;
      public:
	 Exception(const char *message){
	    Exception(message,"Not set.","Not set.",-1);
	 }
	 Exception(const char *message,const char *fileName,
		   const char *functionName,int line){
	    this->message=message;
	    this->fileName=fileName;
	    this->functionName=functionName;
	    this->line=line;
	    std::ostringstream str;
	    
	    //表示するメッセージを作る。
	    str.setf(std::ios::dec, std::ios::basefield);
	    //str<<"---Exception---"<<std::endl; 
	    str<<"Message:"<<message<<std::endl;
	    str<<"FileName:"<<fileName<<std::endl;
	    str<<"Function:"<<functionName<<std::endl;
	    str<<"Line:"<<line<<std::endl;
	    _msg=str.str().c_str();
	 }
	 ~Exception()throw(){}
	 const char* what() const throw(){
	    return _msg;
	 }
	 const char* getFileName() const{
	    return fileName;
	 }
	 const char* getFunctionName() const{
	    return functionName;
	 }
	 const int getLineNum() const{
	    return line;
	 }
      };
      class invalid_operation:public Exception{
      public:
	 invalid_operation(const char *message):
	    Exception(message,"Not set.","Not set.",-1){}
	 invalid_operation(const char *message,const char *fileName,
			   const char *functionName,int line):
	    Exception(message,fileName,functionName,line){}
      };
      class invalid_argument:public Exception{
      public:	 
	 invalid_argument(const char *message):
	    Exception(message,"Not set.","Not set.",-1){}
	 invalid_argument(const char *message,const char *fileName,
			  const char *functionName,int line):
	    Exception(message,fileName,functionName,line){}
      };
   };
};
