#pragma once
#include<WaveStream/Base/Exception.hpp>
#include<WaveStream/Base/CoreUtil.hpp>

namespace LibSynthPP {
   namespace Base {
      class IWaveStream {
	 //あえて、外部から上流、下流と接続しているかを取得できないようにした(基本使わない)
      public:
	 //再生位置取得
	 virtual int64_t getPosition()const=0;

	 //出力フォーマット取得
	 virtual const WaveFormat& getOutputWaveFormat()const=0;
	 //入力フォーマット取得
	 virtual const WaveFormat& getInputWaveFormat()const=0;
	 
	 //完全な初期化。
	 //Resetの処理を内包。
	 //自身に対してメッセージ-1番発行。
	 virtual void clear()=0;

	 //パラメータの初期化を行う。
	 //自身に対してControlMessage-2番発行。
	 virtual void reset()=0;

	 //下流のストリームに対し接続。
	 //接続要求としてメッセージ-3番を送信。
	 //接続するか否かは下流に優先権あり。
	 virtual void connect(
	    IWaveStream *downstream//接続先下位ストリーム
            )=0;

	 //現在接続中のストリームから切断する。
	 //切り離し完了後に下位ストリームに対しメッセージ-4番を送信。
	 //切断するか否かはは上流に優先権あり。
	 virtual void disconnect(
	    IWaveStream *downstream//切り離す下位ストリーム
            )=0;
	 //デストラクタ。
	 virtual ~IWaveStream(){}

	 //protected: //protectedではIWaveStream*から呼べない
	 //ストリームへの書き込み。ユーザは使用不可。
	 //信号の型はストリーム側が判断(接続元の良心に任せる)
	 virtual void _write(
	    IWaveStream *_writerStream,//書き込み元ストリーム。通常this
	    void *signal,//信号配列
	    int64_t length,//信号長
	    int64_t offset//信号オフセット
            )=0;

	 //コントロールメッセージ受信。ユーザは使用不可。
	 virtual void _sendControlMessage(
	    ControlMessage *c//コントロールメッセージ
            )=0;
      };
   };
};
