#pragma once
#include<WaveStream/Base/IWaveStream.hpp>
#include<list>
#include<algorithm>
#include<cstring>
namespace LibSynthPP{
   namespace Core{
      //複数個の下流を持ち、上流からの信号をそのままコピーして送る。
      template<class T>
      class BranchStream : public Base::IWaveStream{
	 Base::IWaveStream *_upstream;
	 std::list<Base::IWaveStream*> _downstreamList;
	 Base::WaveFormat * _waveFormat;
	 int64_t _position;
	 BranchStream(){}
      public:
	 BranchStream(int32_t frequency,int32_t channelNum){
	    _waveFormat=new Base::WaveFormat(frequency,channelNum);
	    _upstream=NULL;
	    clear();
	 }
	 ~BranchStream(){
	    for(std::list<Base::IWaveStream*>::iterator iter=_downstreamList.begin();
		iter!=_downstreamList.end();++iter){
	       disconnect(*(iter));
	    }
	    delete _waveFormat;
	 }
	 int64_t getPosition()const{
	    return _position;
	 }
	 const Base::WaveFormat& getOutputWaveFormat()const{
	    return *_waveFormat;
	 }
	 const Base::WaveFormat& getInputWaveFormat()const{
	    return *_waveFormat;
	 }
	 void clear(){
	    _sendControlMessage(new Base::ControlMessage(-1,this,0,NULL));
	 }
	 void reset(){
	    _sendControlMessage(new Base::ControlMessage(-2,this,0,NULL));
	 }
	 void connect(IWaveStream *downstream){
	    std::list<Base::IWaveStream*>::iterator iter
	       =std::find(_downstreamList.begin(),_downstreamList.end(),downstream);
	    if(iter!=_downstreamList.end()){
	       THROW(Base::invalid_argument,"Already Connected");
	    }else{
	       downstream->_sendControlMessage(
		  new Base::ControlMessage(-3,this,0,NULL)
		  );
	       _downstreamList.push_back(downstream);
	    }
	 }
	 void disconnect(IWaveStream *downstream){
	    std::list<Base::IWaveStream*>::iterator iter
	       =std::find(_downstreamList.begin(),_downstreamList.end(),downstream);
	    if(iter==_downstreamList.end()){
	       THROW(Base::invalid_argument,"Not Connected.");
	    }else{
	       (*iter)->_sendControlMessage(
		  new Base::ControlMessage(-4,this,0,NULL)
		  );
	       _downstreamList.erase(iter);
	    }
	 }
	 void _write(IWaveStream *_writerStream,void *signal, int64_t length,int64_t offset){
	    //受け取った信号をコピーして出力。
	    //元データは削除(もったいないが)
	    if(_downstreamList.size()==0){
	       THROW(Base::invalid_operation,"Not Connected.");
	    }
	    for(std::list<Base::IWaveStream*>::iterator iter=_downstreamList.begin();
		iter!=_downstreamList.end();++iter){
	       T *tmpSignal=new T[length*_waveFormat->getChannelNum()];
	       std::memcpy(tmpSignal,signal,sizeof(T)*length*_waveFormat->getChannelNum());
	       (*iter)->_write(this,tmpSignal,length,offset);
	    }
	    delete (T*)signal;
	    _position+=length;
	 }

	 void _sendControlMessage(Base::ControlMessage *c){
	    switch(c->getMessageID()){
	       case -1: //clear
		  _position=0;
	       case -2: //reset。clearから流れてくる。
		  break;
	       case -3: //connect
		  //チャネル数が一致すれば接続可能。
	       {
		  Base::IWaveStream *sender=c->getSender();
		  if(sender->getOutputWaveFormat()==_waveFormat){
		     _upstream=sender;
		  }else{
		     THROW(Base::invalid_operation,"Wave format missmatch.");
		  }
	       }
	       break;
	       case -4: //disconnect
	       {
		  //接続中のストリームであれば、切断する。
		  Base::IWaveStream *sender=c->getSender();
		  if(sender!=_upstream){
		     THROW(Base::invalid_operation,"Not Connected.");
		  }else{
		     _upstream=NULL;
		  }
	       }
	       break;
	       default:
		  THROW(Base::invalid_argument,"Undefined message.");
	    }
	 }
      };
   };
};
