#pragma once
#include<WaveStream/Base/IWaveStream.hpp>
#include<map>
#include<algorithm>
namespace LibSynthPP{
   namespace Core{
      //複数個の下流を持ち、どれか一つに対して信号を出力する。
      template<class T>
      class DemultiplexerStream : public Base::IWaveStream{
	 Base::IWaveStream *_upstream,*_outputstream;
	 Base::ControlMessageManager _msgMgr;
	 std::list<Base::IWaveStream*> _downstreamList;
	 Base::WaveFormat *_waveFormat;
	 int64_t _position;
	 DemultiplexerStream(){}
      public:
	 DemultiplexerStream(int32_t frequency,int32_t channelNum){
	    _waveFormat=new Base::WaveFormat(frequency,channelNum);
	    _upstream=_outputstream=NULL;
	    clear();
	 }
	 ~DemultiplexerStream(){
	    for(std::list<Base::IWaveStream*>::iterator iter=_downstreamList.begin();
		iter!=_downstreamList.end();++iter){
	       disconnect(*(iter));
	    }
	    delete _waveFormat;
	 }
	 int64_t getPosition()const{
	    return _position;
	 }
	 const Base::WaveFormat& getOutputWaveFormat()const{
	    return *_waveFormat;
	 }
	 const Base::WaveFormat& getInputWaveFormat()const{
	    return *_waveFormat;
	 }
	 void clear(){
	    _sendControlMessage(new Base::ControlMessage(-1,this,0,NULL));
	 }
	 void reset(){
	    _sendControlMessage(new Base::ControlMessage(-2,this,0,NULL));
	 }
	 void connect(IWaveStream *downstream){
	    std::list<Base::IWaveStream*>::iterator iter
	       =std::find(_downstreamList.begin(),_downstreamList.end(),downstream);
	    if(iter!=_downstreamList.end()){
	       THROW(Base::invalid_argument,"Already Connected");
	    }else{
	       downstream->_sendControlMessage(
		  new Base::ControlMessage(-3,this,0,NULL)
		  );
	       _downstreamList.push_back(downstream);
	       if(_outputstream==NULL){
		  _outputstream=downstream;
	       }
	    }
	 }
	 void disconnect(IWaveStream *downstream){
	    std::list<Base::IWaveStream*>::iterator iter
	       =std::find(_downstreamList.begin(),_downstreamList.end(),downstream);
	    if(iter==_downstreamList.end()){
	       THROW(Base::invalid_argument,"Not Connected.");
	    }else{
	       (*iter)->_sendControlMessage(
		  new Base::ControlMessage(-4,this,0,NULL)
		  );
	       if((*iter)==_outputstream){
		  _outputstream=NULL;
	       }
	       _downstreamList.erase(iter);
	    }
	 }
	 //出力先の変更
	 void changeOutputStream(IWaveStream *outputStream,int64_t time){
	    _sendControlMessage(new Base::ControlMessage(1,this,time,outputStream));
	 }
	 void _write(IWaveStream *_writerStream,void *signal, int64_t length,int64_t offset){
	    //受け取った信号をコピーして出力。
	    //元データは削除(もったいないが)
	    if(_downstreamList.size()==0){
	       THROW(Base::invalid_operation,"Not Connected.");
	    }else if(offset!=0){
	       THROW(Base::invalid_argument,"Offset is not supported.");
	    }
	    int64_t processed=0;
	    std::list<Base::ControlMessage*> *msgList=_msgMgr.getMessage(_position+length);
	    for(std::list<Base::ControlMessage*>::iterator iter=msgList->begin();
		iter!=msgList->end();++iter){
	       int64_t size=(*iter)->getTime()-processed-_position;
	       T *tmp=new T[size*_waveFormat->getChannelNum()];
	       memcpy(tmp,(((T*)signal)+processed*_waveFormat->getChannelNum()),
		      sizeof(T)*_waveFormat->getChannelNum());
	       _outputstream->_write(this,tmp,size,processed);
	       switch((*iter)->getMessageID()){
		  case 1://出力先変更		  
		     if(std::find(_downstreamList.begin(),_downstreamList.end(),
				  (Base::IWaveStream*)((*iter)->getParam()))!=_downstreamList.end()){
			_outputstream=(Base::IWaveStream*)((*iter)->getParam());
		     }else{
			THROW(Base::invalid_argument,"Not connected.");
		     }
		     break;
		  case 0://番兵
		     break;
	       }
	       delete *iter;
	       processed+=size;
	    }
	    delete msgList;
	    delete (T*)signal;
	    _position+=length;
	 }

	 void _sendControlMessage(Base::ControlMessage *c){
	    switch(c->getMessageID()){
	       case -1: //clear
		  _position=0;
		  _msgMgr.clear();
	       case -2: //reset。clearから流れてくる。
		  break;
	       case -3: //connect
		  //チャネル数が一致すれば接続可能。
	       {
		  Base::IWaveStream *sender=c->getSender();
		  if(_upstream != NULL){
                     THROW(Base::invalid_operation,"Already Connected.");
                  }else if(!(sender->getOutputWaveFormat()==_waveFormat)){
		     THROW(Base::invalid_operation,"Wave format missmatch.");
		  }
		  //問題が無かったので接続。
		  _upstream = sender;
	       }
	       break;
	       case -4: //disconnect
	       {
		  //接続中のストリームであれば、切断する。
		  Base::IWaveStream *sender=c->getSender();
		  if(sender!=_upstream){
		     THROW(Base::invalid_operation,"Not Connected.");
		  }else{
		     _upstream=NULL;
		  }
	       }
	       break;
	       case 1://出力先変更
		  //この場で即切り替えはなし。
		  _msgMgr.addMessage(c);
		  break;
	       default:
		  THROW(Base::invalid_argument,"Undefined message.");
	    }
	 }
      };
   };
};
