#pragma once
#include<WaveStream/Base/IWaveStream.hpp>
#include<WaveStream/Util/WaveBuffer.hpp>

#include<list>
namespace LibSynthPP{
   namespace Core{
      template<class T>
      class MargerStream : public Base::IWaveStream{
	 Base::IWaveStream *_downstream;
	 Util::WaveMixerBuffer<T> *_mixer;
	 std::list<Base::IWaveStream*> _upstreamList;
	 Base::WaveFormat *_waveFormat;
	 int64_t _position;
	 MargerStream(){}
      public:
	 MargerStream(int32_t frequency,int32_t channelNum){
	    _waveFormat=new Base::WaveFormat(frequency,channelNum);
	    _downstream=NULL;
	    _mixer=new Util::WaveMixerBuffer<T>(channelNum);
	    clear();
	 }
	 ~MargerStream(){
	    if(_downstream!=NULL){
	       disconnect(_downstream);
	    }
	    delete _waveFormat;
	 }
	 int64_t getPosition()const{
	    return _position;
	 }
	 const Base::WaveFormat& getOutputWaveFormat()const{
	    return *_waveFormat;
	 }
	 const Base::WaveFormat& getInputWaveFormat()const{
	    return *_waveFormat;
	 }
	 void clear(){
	    _sendControlMessage(new Base::ControlMessage(-1,this,0,NULL));
	 }
	 void reset(){
	    _sendControlMessage(new Base::ControlMessage(-2,this,0,NULL));
	 }
	 void connect(IWaveStream *downstream){
	    if(_downstream!=NULL){
	       THROW(Base::invalid_operation,"Already Connected.");
	    }else{
	       downstream->_sendControlMessage(
		  new Base::ControlMessage(-3,this,0,NULL)
		  );
	       _downstream=downstream;
	    }
	 }
	 void disconnect(IWaveStream *downstream){
	    if(_downstream != downstream){
	       THROW(Base::invalid_argument,"Not Connected.");
	    }else{
	       downstream->_sendControlMessage(
		  new Base::ControlMessage(-4,this,0,NULL)
		  );
	       _downstream=NULL;
	    }
	 }
	 void _write(IWaveStream *_writerStream,void *signal, int64_t length,int64_t offset){
	    //バッファへ書き込み
	    if(std::find(_upstreamList.begin(),_upstreamList.end(),
			 _writerStream)==_upstreamList.end()){
	       THROW(Base::invalid_argument,"Not connected.");
	    }
	    _mixer->write((T*)signal,length,offset);
	 }

	 void _sendControlMessage(Base::ControlMessage *c){
	    switch(c->getMessageID()){
	       case -1: //clear
		  _position=0;
	       case -2: //reset。clearから流れてくる。
		  _mixer->clear();
		  break;
	       case -3: //connect
		  //チャネル数が一致すれば接続可能。
	       {
		  Base::IWaveStream *sender=c->getSender();
		  if(!(sender->getOutputWaveFormat()==_waveFormat)){
		     THROW(Base::invalid_operation,"Wave format missmatch.");
		  }
		  if(std::find(_upstreamList.begin(),_upstreamList.end(),sender)!=_upstreamList.end()){
		     THROW(Base::invalid_operation,"Already Connected.");
		  }
		  //問題がなかったので接続。
		  _upstreamList.push_back(sender);
	       }
	       break;
	       case -4: //disconnect
	       {
		  //接続中のストリームであれば、切断する。
		  Base::IWaveStream *sender=c->getSender();
		  std::list<IWaveStream*>::iterator iter=
		     std::find(_upstreamList.begin(),_upstreamList.end(),sender);
		  if(iter==_upstreamList.end()){
		     THROW(Base::invalid_operation,"Not Connected.");
		  }else{
		     _upstreamList.erase(iter);
		  }
	       }
	       break;
	       default:
		  THROW(Base::invalid_argument,"Undefined message.");
	    }
	 }
	 void flash(int64_t length,int64_t offset){
	    //ミキサバッファをフラッシュする。
	    T *signal=_mixer->read(length);
	    _downstream->_write(this,signal,length,offset);
	    _position+=length;
	 }
      };
   };
};
