#pragma once
#include<WaveStream/Base/IWaveStream.hpp>
#include<cstring>
namespace LibSynthPP{
   namespace Core{
      //float型の配列を受け取り、それを下位ストリームに出力するストリーム
      template<class T>
      class MemoryInputStream : public Base::IWaveStream{
	 IWaveStream *_downstream;
	 Base::WaveFormat *_inputWaveFormat,*_outputWaveFormat;
	 int64_t _position;
	 MemoryInputStream(){}
      public:
	 MemoryInputStream(int32_t frequency,int32_t channelNum){
	    _inputWaveFormat=Base::WaveFormat::createNullWaveFormat();
	    _outputWaveFormat=new Base::WaveFormat(frequency,channelNum);
	    _downstream=NULL;
	    clear();
	 }
	 ~MemoryInputStream(){
	    if(_downstream!=NULL){
	       disconnect(_downstream);
	    }
	    delete _inputWaveFormat;
	    delete _outputWaveFormat;
	 }
	 int64_t getPosition()const{
	    return _position;
	 }
	 const Base::WaveFormat& getOutputWaveFormat()const{
	    return *_outputWaveFormat;
	 }
	 const Base::WaveFormat& getInputWaveFormat()const{
	    return *_inputWaveFormat;
	 }
	 void clear(){
	    _sendControlMessage(new Base::ControlMessage(-1,this,0,NULL));
	 }
	 void reset(){
	    _sendControlMessage(new Base::ControlMessage(-2,this,0,NULL));
	 }
	 void connect(IWaveStream *downstream){
	    if(_downstream!=NULL){
	       THROW(Base::invalid_operation,"Already Connected.");
	    }else{
	       downstream->_sendControlMessage(
		  new Base::ControlMessage(-3,this,0,NULL)
		  );
	       _downstream=downstream;
	    }
	 }
	 void disconnect(IWaveStream *downstream){
	    if(_downstream != downstream){
	       THROW(Base::invalid_argument,"Not Connected.");
	    }else{
	       downstream->_sendControlMessage(
		  new Base::ControlMessage(-4,this,0,NULL)
		  );
	       _downstream=NULL;
	    }
	 }
	 void _write(IWaveStream *_writerStream,void *signal, int64_t length,int64_t offset){
	    //最上位なので使えない
	    THROW(Base::invalid_operation,"Can't _write in this stream.");
	 }
	 void _sendControlMessage(Base::ControlMessage *c){
	    switch(c->getMessageID()){
	       case -1: //clear
		  _position=0;
	       case -2: //reset。clearから流れてくる。
		  break;
	       case -3: //connect
	       case -4: //disconnect
		  //最上位ストリームなので
		  THROW(Base::invalid_operation,"It's topmost stream.");
		  break;
	       default:
		  THROW(Base::invalid_argument,"Undefined message.");
	    }
	 }
	 void writeSignal(T *signal,int64_t length,int64_t offset,bool isCopy=false){
	    //引数で受け取った信号を流し込む。
	    //isCopyがfalseの時はコピーはとらない(デフォルト)。
	    if(_downstream==NULL){
	       THROW(Base::invalid_operation,"Not conneted.");
	    }else{
	       if(isCopy==false){
		  _downstream->_write(this,signal,length,offset);
	       }else{
		  T *tmpSignal=new T[length*_outputWaveFormat->getChannelNum()];
		  memcpy(tmpSignal,signal,sizeof(T)*length*_outputWaveFormat->getChannelNum());
		  _downstream->_write(this,tmpSignal,length,offset);
	       }
	       _position+=length;
	    }
	 }
      };
   };
};
