#pragma once
#include<WaveStream/Base/IWaveStream.hpp>
#include<WaveStream/Util/WaveBuffer.hpp>
namespace LibSynthPP{
   namespace Core{
      //受け取った信号を保存し、ユーザが取り出せるようにしたストリーム。
      template<class T>
      class MemoryOutputStream : public Base::IWaveStream{
	 Base::IWaveStream *_upstream;
	 Base::WaveFormat *_inputWaveFormat,*_outputWaveFormat;
	 int64_t _position;
	 Util::WaveBuffer<T> *_wb;
	 MemoryOutputStream(){}
      public:
	 MemoryOutputStream(int32_t frequency,int32_t channelNum){
	    _inputWaveFormat=new Base::WaveFormat(frequency,channelNum);
	    _outputWaveFormat=Base::WaveFormat::createNullWaveFormat();
	    _upstream=NULL;
	    _wb=new Util::WaveBuffer<T>(channelNum);
	    clear();
	 }
	 ~MemoryOutputStream(){
	    if(_wb!=NULL){
	       delete _wb;
	    }
	    delete _inputWaveFormat;
	    delete _outputWaveFormat;
	 }
	 int64_t getPosition()const{
	    return _position;
	 }
	 int64_t getBufferSize()const{
	    return _wb->getLength();
	 }
	 const Base::WaveFormat& getInputWaveFormat()const{
	    return *_inputWaveFormat;
	 }
	 const Base::WaveFormat& getOutputWaveFormat()const{
	    return *_outputWaveFormat;
	 }
	 void clear(){
	    _sendControlMessage(new Base::ControlMessage(-1,this,0,NULL));
	 }
	 void reset(){
	    _sendControlMessage(new Base::ControlMessage(-2,this,0,NULL));
	 }
	 void connect(IWaveStream *downstream){
	    //最下流なので、どこにも接続できない。
	    THROW(Base::invalid_operation,"It's the most downstream.");
	 }
	 void disconnect(IWaveStream *downstream){
	    //最下流なので、そもそも接続していない。
	    THROW(Base::invalid_argument,"Not Connected.");
	 }
	 void _write(IWaveStream *_writerStream,void *signal, int64_t length,int64_t offset){
	    //来たものをそのままWaveBufferへ放り込む。
	    if(offset!=0){
	       THROW(Base::invalid_argument,"Offset is not supported.");
	    }
	    _wb->write((T*)signal,length);
	 }
	 T* readSignal(int64_t length){
	    //指定された長さだけ、信号を切り出す。
	    if(_wb->getLength()>length){
	       THROW(Base::invalid_argument,"Too long length.");
	    }
	    _position+=length;
	    return _wb->read(length);
	 }
	 void _sendControlMessage(Base::ControlMessage *c){
	    switch(c->getMessageID()){
	       case -1: //clear
		  _position=0;
	       case -2: //reset。clearから流れてくる。
		  _wb->clear();
		  break;
	       case -3: //connect
		  //チャネル数が一致すれば接続可能。
	       {
		  Base::IWaveStream *sender=c->getSender();
		  if(sender->getOutputWaveFormat()==_inputWaveFormat){
		     _upstream=sender;
		  }else{
		     THROW(Base::invalid_operation,"Wave format missmatch.");
		  }
	       }
	       break;
	       case -4: //disconnect
	       {
		  //接続中のストリームであれば、切断する。
		  Base::IWaveStream *sender=c->getSender();
		  if(_upstream != NULL){
                     THROW(Base::invalid_operation,"Already Connected.");
                  }else if(sender!=_upstream){
		     THROW(Base::invalid_operation,"Not Connected.");
		  }else{
		     _upstream=NULL;
		  }
	       }
	       break;
	       default:
		  THROW(Base::invalid_argument,"Undefined message.");
	    }
	 }
      };
   };
};
