#pragma once
#include<WaveStream/Base/IWaveStream.hpp>

namespace LibSynthPP{
   namespace Core{
      template<class T>
      class NullFilterStream : public Base::IWaveStream{
	 Base::IWaveStream *_downstream,*_upstream;
	 Base::WaveFormat* _waveFormat;
	 int64_t _position;
	 NullFilterStream(){}
      public:
	 NullFilterStream(int32_t frequency,int32_t channelNum){
	    _waveFormat=new Base::WaveFormat(frequency,channelNum);
	    _downstream=_upstream=NULL;
	    clear();
	 }
	 ~NullFilterStream(){
	    if(_downstream!=NULL){
	       disconnect(_downstream);
	    }
	    delete _waveFormat;
	 }
	 int64_t getPosition()const{
	    return _position;
	 }
	 const Base::WaveFormat& getOutputWaveFormat()const{
	    return *_waveFormat;
	 }
	 const Base::WaveFormat& getInputWaveFormat()const{
	    return *_waveFormat;
 	 }
	 void clear(){
	    _sendControlMessage(new Base::ControlMessage(-1,this,0,NULL));
	 }
	 void reset(){
	    _sendControlMessage(new Base::ControlMessage(-2,this,0,NULL));
	 }
	 void connect(IWaveStream *downstream){
	    if(_downstream!=NULL){
	       THROW(Base::invalid_operation,"Already Connected.");
	    }else{
	       downstream->_sendControlMessage(
		  new Base::ControlMessage(-3,this,0,NULL)
		  );
	       _downstream=downstream;
	    }
	 }
	 void disconnect(IWaveStream *downstream){
	    if(_downstream != downstream){
	       THROW(Base::invalid_argument,"Not Connected.");
	    }else{
	       downstream->_sendControlMessage(
		  new Base::ControlMessage(-4,this,0,NULL)
		  );
	       _downstream=NULL;
	    }
	 }
	 void _write(IWaveStream *_writerStream,void *signal, int64_t length,int64_t offset){
	    //そのまま転送
	    if(_downstream==NULL){
	       THROW(Base::invalid_operation,"Not Connected.");
	    }
	    _downstream->_write(this,signal,length,offset);
	    _position+=length;
	 }

	 void _sendControlMessage(Base::ControlMessage *c){
	    switch(c->getMessageID()){
	       case -1: //clear
		  _position=0;
	       case -2: //reset。clearから流れてくる。
		  break;
	       case -3: //connect
		  //チャネル数が一致すれば接続可能。
	       {
		  Base::IWaveStream *sender=c->getSender();
		  if(_upstream != NULL){
		     THROW(Base::invalid_operation,"Already Connected.");
		  }else if(sender->getOutputWaveFormat()==_waveFormat){
		     _upstream=sender;
		  }else{
		     THROW(Base::invalid_operation,"Wave format missmatch.");
		  }
	       }
	       break;
	       case -4: //disconnect
	       {
		  //接続中のストリームであれば、切断する。
		  Base::IWaveStream *sender=c->getSender();
		  if(sender!=_upstream){
		     THROW(Base::invalid_operation,"Not Connected.");
		  }else{
		     _upstream=NULL;
		  }
	       }
	       break;
	       default:
		  THROW(Base::invalid_argument,"Undefined message.");
	    }
	 }
      };
   };
};
