#pragma once
#include<WaveStream/Base/IWaveStream.hpp>
#include<cstring>
namespace LibSynthPP{
   namespace Core{
      template<class T>
      class NullInputStream : public Base::IWaveStream{
	 IWaveStream *_downstream;
	 Base::WaveFormat *_inputWaveFormat,*_outputWaveFormat;
	 int64_t _position;

	 NullInputStream(){}
      public:
	 NullInputStream(int32_t frequency,int32_t channelNum){
	    _inputWaveFormat=Base::WaveFormat::createNullWaveFormat();
	    _outputWaveFormat=new Base::WaveFormat(frequency,channelNum);
	    _downstream=NULL;
	    clear();
	 }
	 ~NullInputStream(){
	    if(_downstream!=NULL){
	       disconnect(_downstream);
	    }
	    delete _inputWaveFormat;
	    delete _outputWaveFormat;
	 }
	 int64_t getPosition()const{
	    return _position;
	 }
	 const Base::WaveFormat& getInputWaveFormat()const{
	    return *_inputWaveFormat;
	 }
	 const Base::WaveFormat& getOutputWaveFormat()const{
	    return *_outputWaveFormat;
	 }	 
	 void clear(){
	    _sendControlMessage(new Base::ControlMessage(-1,this,0,NULL));
	 }
	 void reset(){
	    _sendControlMessage(new Base::ControlMessage(-2,this,0,NULL));
	 }
	 void connect(IWaveStream *downstream){
	    if(_downstream!=NULL){
	       THROW(Base::invalid_operation,"Already Connected.");
	    }else{
	       downstream->_sendControlMessage(
		  new Base::ControlMessage(-3,this,0,NULL)
		  );
	       _downstream=downstream;
	    }
	 }
	 void disconnect(IWaveStream *downstream){
	    if(_downstream != downstream){
	       THROW(Base::invalid_argument,"Not Connected.");
	    }else{
	       downstream->_sendControlMessage(
		  new Base::ControlMessage(-4,this,0,NULL)
		  );
	       _downstream=NULL;
	    }
	 }
	 void _write(IWaveStream *_writerStream,void *signal, int64_t length,int64_t offset){
	    //最上位なので使えない
	    THROW(Base::invalid_operation,"Can't write in this stream.");
	 }
	 void _sendControlMessage(Base::ControlMessage *c){
	    switch(c->getMessageID()){
	       case -1: //clear
		  _position=0;
	       case -2: //reset。clearから流れてくる。
		  break;
	       case -3: //connect
	       case -4: //disconnect
		  //最上位ストリームなので
		  THROW(Base::invalid_operation,"It's topmost stream.");
		  break;
	       default:
		  THROW(Base::invalid_argument,"Undefined message.");
	    }
	 }
	 void generateSignal(int64_t length,int64_t offset){
	    //length分だけ空の信号を生成する。
	    if(_downstream==NULL){
	       THROW(Base::invalid_operation,"Not conneted.");
	    }else{
	       T *signal=new T[length*_inputWaveFormat->getChannelNum()];
	       memset(signal,0,sizeof(T)*length*_inputWaveFormat->getChannelNum());
	       _downstream->_write(this,signal,length,offset);
	       _position+=length;
	    }
	 }
      };
   };
};
