#pragma once
#include<WaveStream/Base/IWaveStream.hpp>

namespace LibSynthPP{
   namespace DSP{
      template<class Tsig,class Tvol>
      class AmplifierStream : public Base::IWaveStream{
	 Base::IWaveStream *_downstream,*_upstream;
	 Base::ControlMessageManager _msgMgr;
	 Base::WaveFormat *_waveFormat;
	 int64_t _position;
	 Tvol _volume,_defaultVolume;
	 AmplifierStream(){}
      public:
	 AmplifierStream(int32_t frequency,int32_t channelNum,Tvol defaultVolume){
	    _waveFormat=new Base::WaveFormat(frequency,channelNum);
	    _volume=_defaultVolume=defaultVolume;
	    _downstream=_upstream=NULL;
	    clear();
	 }
	 ~AmplifierStream(){
	    if(_downstream!=NULL){
	       disconnect(_downstream);
	    }
	    delete _waveFormat;
	 }
	 int64_t getPosition()const{
	    return _position;
	 }
	 const Base::WaveFormat& getOutputWaveFormat()const{
	    return *_waveFormat;
	 }
	 const Base::WaveFormat& getInputWaveFormat()const{
	    return *_waveFormat;
	 }
	 void clear(){
	    _sendControlMessage(new Base::ControlMessage(-1,this,0,NULL));
	 }
	 void reset(){
	    _sendControlMessage(new Base::ControlMessage(-2,this,0,NULL));
	 }
	 void connect(IWaveStream *downstream){
	    if(_downstream!=NULL){
	       THROW(Base::invalid_operation,"Already Connected.");
	    }else{
	       downstream->_sendControlMessage(
		  new Base::ControlMessage(-3,this,0,NULL)
		  );
	       _downstream=downstream;
	    }
	 }
	 void disconnect(IWaveStream *downstream){
	    if(_downstream != downstream){
	       THROW(Base::invalid_argument,"Not Connected.");
	    }else{
	       downstream->_sendControlMessage(
		  new Base::ControlMessage(-4,this,0,NULL)
		  );
	       _downstream=NULL;
	    }
	 }
	 void _write(IWaveStream *_writerStream,void *signal, int64_t length,int64_t offset){
	    //音量を変更して転送
	    if(_downstream==NULL){
	       THROW(Base::invalid_operation,"Not Connected.");
	    }
	    Tsig *ptr=(Tsig*)signal;
	    int64_t processed=0;
	    //制御メッセージ取得
	    std::list<Base::ControlMessage*> *msgList=_msgMgr.getMessage(_position+length);
	    for(std::list<Base::ControlMessage*>::iterator iter=msgList->begin();
		iter!=msgList->end();++iter){
	       int64_t size=(*iter)->getTime()-processed-_position;
	       for(int64_t i=0;i<size*_waveFormat->getChannelNum();++i,++ptr){
		  *ptr*=_volume;
	       }
	       switch((*iter)->getMessageID()){
		  case 1://ボリューム変更
		  {
		     Tvol *vol=(Tvol*)((*iter)->getParam());
		     _volume=*vol;
		     delete vol;
		     break;
		  }
		  case 0://番兵
		     break;
	       }
	       processed+=size;
	       delete *iter;
 	    }
	    delete msgList;
	    _downstream->_write(this,signal,length,offset);
	    _position+=length;
	 }
	 void changeVolume(Tvol volume,int64_t time){
	    _sendControlMessage(new Base::ControlMessage(1,this,time,new Tvol(volume)));
	 }
	 void _sendControlMessage(Base::ControlMessage *c){
	    switch(c->getMessageID()){
	       case -1: //clear
		  _position=0;
		  _msgMgr.clear();
	       case -2: //reset。clearから流れてくる。
		  _volume=_defaultVolume;
		  break;
	       case -3: //connect
		  //チャネル数が一致すれば接続可能。
	       {
		  Base::IWaveStream *sender=c->getSender();
		  if(!(sender->getOutputWaveFormat()==_waveFormat)){
		     THROW(Base::invalid_operation,"Wave format missmatch.");
		  }
		  _upstream=sender;
	       }
	       break;
	       case -4: //disconnect
	       {
		  //接続中のストリームであれば、切断する。
		  Base::IWaveStream *sender=c->getSender();
		  if(sender!=_upstream){
		     THROW(Base::invalid_operation,"Not Connected.");
		  }else{
		     _upstream=NULL;
		  }
	       }
	       break;
	       case 1://ボリューム変更
		  _msgMgr.addMessage(c);
		  break;
	       default:
		  THROW(Base::invalid_argument,"Undefined message.");
	    }
	 }
      };
   };
};
