#pragma once
#include<cstring>
#include<cmath>
#include<WaveStream/Base/typedef.hpp>
#include<WaveStream/Base/Exception.hpp>

namespace LibSynthPP {
   namespace Util {
      //双二次フィルタクラス
      template<class Tsig,class Tparam>
      class BiquadraticFilter{
	 Tsig x[2],y[2];
	 int idx1,idx2;
	 Tparam a0,a1,a2,b0,b1,b2;
      public:
	 //コンストラクタ
	 BiquadraticFilter(){
	    clear();
	 }
	 //初期化
	 void clear(){
	    x[0]=y[0]=x[1]=y[1]=0;
	    idx1=0;
	    idx2=1;
	    resetParam();
	 }
	 //出力更新
	 Tsig update(Tsig x0){
	    Tsig y0=(Tsig)((b0*x0 +b1*x[idx1] +b2*x[idx2]
			    -a1*y[idx1] -a2*y[idx2])/a0);
	    x[idx2]=x0;y[idx2]=y0;
	    idx1^=0x01;
	    idx2^=0x01;
	    return y0;
	 }
	 //初期パラメータ設定
	 void resetParam(){
	    a0=b0=1;
	    a1=a2=b1=b2=0;
	 }
	 //ローパスフィルタ設定
	 void setLopassParam(Tparam sampleFreq, Tparam cutOffFreq, Tparam Q) {
            Tparam w0 =(Tparam)( 2 * M_PI * cutOffFreq / sampleFreq);
            Tparam sinw0 = (Tparam)std::sin(w0), cosw0 = (Tparam)std::cos(w0);
            Tparam alpha = (2 * sinw0 / Q);
            b0 = (1 - cosw0) / 2;
            b1 = 1 - cosw0;
            b2 = b0;
            a0 = 1 + alpha;
            a1 = -2 * cosw0;
            a2 = 1 - alpha;
	 }
	 //ハイパスフィルタ設定
	 void setHighpassParam(Tparam sampleFreq,Tparam cutOffFreq,Tparam Q) {
            Tparam w0 = (Tparam)(2 * M_PI * cutOffFreq / sampleFreq);
            Tparam sinw0 = (Tparam)sin(w0),cosw0 = (Tparam)cos(w0);
            Tparam alpha = (2 * sinw0 / Q);
            b0 = (1 + cosw0) / 2;
            b1 = -(1 + cosw0);
            b2 = b0;
            a0 = 1 + alpha;
            a1 = -2 * cosw0;
            a2 = 1 - alpha;
	 }
	 //バンドパス1設定
	 void setBandpass1Param(Tparam sampleFreq, Tparam centerFreq, Tparam BW) {
	    Tparam w0 = (Tparam)(2 * M_PI * centerFreq / sampleFreq);
	    Tparam sinw0 = (Tparam)sin(w0), cosw0 = (Tparam)cos(w0);
	    Tparam alpha = (2 * sinw0 / BW);
	    b0 = BW * alpha;
	    b1 = 0;
	    b2 = -BW * alpha;
	    a0 = 1 + alpha;
	    a1 = -2 * cosw0;
	    a2 = 1 - alpha;
	 }
	 //バンドパス2設定
	 void setBandpass2Param(Tparam sampleFreq, Tparam centerFreq, Tparam BW) {
            Tparam w0 = (Tparam)(2 * M_PI * centerFreq / sampleFreq);
            Tparam sinw0 = (Tparam)sin(w0), cosw0 = (Tparam)cos(w0);
            Tparam alpha = (Tparam)(sinw0 * sinh(log(2.0) * BW * w0 / sinw0));
            b0 = alpha;
            b1 = 0;
            b2 = -alpha;
            a0 = 1 + alpha;
            a1 = -2 * cosw0;
            a2 = 1 - alpha;
	 }
	 //バンドストップ設定
	 void setBandstopParam(Tparam sampleFreq,Tparam centerFreq,Tparam BW) {
            Tparam w0 = (Tparam)(2 * M_PI * centerFreq / sampleFreq);
            Tparam sinw0 = (Tparam)sin(w0), cosw0 = (Tparam)cos(w0);
            Tparam alpha = (Tparam)(sinw0 * sinh(log(2.0) * BW * w0 / sinw0));
            b0 = 1;
            b1 = -2 * cosw0;
            b2 = 1;
            a0 = 1 + alpha;
            a1 = -2 * cosw0;
            a2 = 1 - alpha;
	 }
	 //オールパス設定
	 void setAllpassParam(Tparam sampleFreq,Tparam cutOffFreq,float BW) {
            Tparam w0 = (Tparam)(2 * M_PI * cutOffFreq / sampleFreq);
            Tparam sinw0 = (Tparam)sin(w0), cosw0 = (Tparam)cos(w0);
            Tparam alpha = (Tparam)(sinw0 * sinh(log(2.0) * BW * w0 / sinw0));
            b0 = 1 - alpha;
            b1 = -2 * cosw0;
            b2 = 1 + alpha;
            a0 = 1 + alpha;
            a1 = -2 * cosw0;
            a2 = 1 - alpha;
	 }
	 //ピーキング設定
	 void setPeakingParam(Tparam sampleFreq,Tparam centerFreq,Tparam BW,Tparam gain) {
            Tparam w0 = (Tparam)(2 * M_PI * centerFreq / sampleFreq);
            Tparam sinw0 = (Tparam)sin(w0), cosw0 = (Tparam)cos(w0);
            Tparam alpha = (Tparam)(sinw0 * sinh(log(2.0) * BW * w0 / sinw0));
            Tparam A = (Tparam)(sqrt(pow(10, gain / 20)));
            b0 = 1 + alpha * A;
            b1 = -2 * cosw0;
            b2 = 1 - alpha * A;
            a0 = 1 + alpha / A;
            a1 = -2 * cosw0;
            a2 = 1 - alpha / A;
	 }
	 //ローシェルフ設定
	 void setLoshelfParam(Tparam sampleFreq,Tparam cutOffFreq,Tparam S,Tparam gain) {
            Tparam w0 = (Tparam)(2 * M_PI * cutOffFreq / sampleFreq);
            Tparam sinw0 = (Tparam)sin(w0), cosw0 = (Tparam)cos(w0);
            Tparam A = (Tparam)(sqrt(pow(10, gain / 20)));
            Tparam alpha = (Tparam)(sinw0 / 2 * sqrt((A + 1 / A) * (1 / S - 1) + 2));
            Tparam sqrtA = (Tparam)sqrt(A);
            b0 = A * ((A + 1) - (A - 1) * cosw0 + 2 * sqrtA * alpha);
            b1 = 2 * A * ((A - 1) - (A + 1) * cosw0);
            b2 = A * ((A + 1) - (A - 1) * cosw0 - 2 * sqrtA * alpha);
            a0 = (A + 1) + (A - 1) * cosw0 + 2 * sqrtA * alpha;
            a1 = -2 * ((A - 1) + (A + 1) * cosw0);
            a2 = (A + 1) + (A - 1) * cosw0 - 2 * sqrtA * alpha;
	 }
	 //ハイシェルフ設定
	 void setHighshelfParam(Tparam sampleFreq,Tparam cutOffFreq,Tparam S,Tparam gain) {
            Tparam w0 = (Tparam)(2 * M_PI * cutOffFreq / sampleFreq);
            Tparam sinw0 = (Tparam)sin(w0), cosw0 = (Tparam)cos(w0);
            Tparam A = (Tparam)sqrt(pow(10, gain / 20));
            Tparam alpha = (Tparam)(sinw0 / 2 * sqrt((A + 1 / A) * (1 / S - 1) + 2));
            Tparam sqrtA = (Tparam)sqrt(A);
            b0 = A * ((A + 1) + (A - 1) * cosw0 + 2 * sqrtA * alpha);
            b1 = -2 * A * ((A - 1) + (A + 1) * cosw0);
            b2 = A * ((A + 1) + (A - 1) * cosw0 - 2 * sqrtA * alpha);
            a0 = (A + 1) - (A - 1) * cosw0 + 2 * sqrtA * alpha;
            a1 = 2 * ((A - 1) - (A + 1) * cosw0);
            a2 = (A + 1) - (A - 1) * cosw0 - 2 * sqrtA * alpha;
	 }
      };
   };
};
