#! /usr/bin/perl
# info ե뷲顢database 륹ץ
# $Id: genindex.pl,v 1.5 2002/11/12 10:58:36 mdk Exp $
#
# Fujiwara ν񤤤ץȤ١ˤƤ롣
#
# 礹 Berkeley DB file ̾1ˤ뤳ȡ
# info եΥꥹȤ³ˤʤ롣

use strict;
use vars;
use DB_File;
use lib qw(bin);
use jfadmlib qw(:DEFAULT :LOCKS);
use Jcode;

my $database = shift (@ARGV);

unlink $database;
my ($H, %index); $H = tie(%index, 'DB_File', "$database",
			  O_RDWR|O_CREAT, 0644, $DB_BTREE) or die;
lockdb($H, LOCK_EX);

foreach my $file (@ARGV)
{
    my %DBITEM;

    if (!open(CL, $file)) {
	print "Can't open.\n";
	next;
    }

    while (<CL>) {
	last if /DRAFT.NOINDEX/i;  
	s/\s*#.*$//;
	next if /^\s*$/;
	Jcode::convert(\$_, 'euc');
	if (/^(\w+):\s*(.*)$/) {
	    my ($key, $value) = ($1, $2);
	    $value =~ s/\s*$//;
	    $DBITEM{$key} = $value;
	}
    }
    close CL;

    if ($DBITEM{'NAME'}) {
	my $name = $DBITEM{'NAME'};
	foreach my $k (keys %DBITEM) {
	  jfadmlib::add_ent($H, $name, $k, $DBITEM{$k});
	}

    } else {
	print STDERR "$file has no NAME field. (ignored)\n";
	next;
    }
    undef %DBITEM;
}

unlockdb;
undef $H;
untie %index;

# Local variables:
# cperl-indent-level: 4
# End:
