#!/usr/bin/perl
# $Id: latest-docs.pl,v 1.9 2003/02/05 11:15:29 mdk Exp $
#
# news.m4 鿷ʸФ뤿 Perl5 script.
#

use strict;
use Time::Local;
use DB_File;
use lib ("../bin", "../../bin"); # jfadmlib.pm Τǥ쥯ȥ
use jfadmlib;
require 'jcode.pl';

my $indexfile = "./jfindex.db";
if (! -r $indexfile) {
  $indexfile = "../../jfindex.db";
}

# news.m4 λ
my $news_m4 = $ARGV[0];

# Ƕβ֤ doc ɽ뤫
my $recentdays = $ARGV[1];

# ¤Ǥɽ doc ο
my $minitems = $ARGV[2];

# ɽ doc κ¤ο
my $maxitems = 512; #  (߻¾¤ʤ)

my %contrib = (
               'LILO-doc' => 1,
               'LTGP'     => 1,
);

my $url = 'http://www.linux.or.jp/JF';
my %hash;
my $H = tie(%hash, 'DB_File', $indexfile, O_RDONLY, 0644, $DB_BTREE) or die;

my $prevline = '';
my $i = 0;
my $now = time;
my $sec = 60 * 60 * 24 * $recentdays;

my $stat;
my $ext;
my $doc;
my $date;

open(N, $news_m4) or die;
while (<N>) {
    
    if ($prevline) {
	my $kdoc_info = '../../docs/' . $doc . '.info';
	my $orig_doc = $doc;
	if (-r $kdoc_info) {
	    my $cont = get_kdoc_ent($kdoc_info, 'CONT');
	    unless ($cont) {
		$prevline = '';
		next;
	    }

	    $doc =~ /^kernel-docs-(2.[24])\/(.+)$/;
	    my $title = "kernel-$1 ° $2 ܸ";
    	    my $trans_1  = get_kdoc_ent($kdoc_info, 'TRNS');
	    my $trans_2  = get_kdoc_ent($kdoc_info, 'TRN2');
	    my $dir = '/JFdocs/';

	    print " * $title";
	    if ($stat eq "NEW") {
		print " [New]\n";
	    }else {
		print " [Updated]\n";
	    }
	    print "     ά: $cont\n";
#	    print "     : $author\n";
	    print "     : $trans_1\n" if $trans_1;
	    print "           $trans_2\n" if $trans_2;
#	    print "           $trans_3\n" if $trans_3;
#	    print "           $trans_4\n" if $trans_4;
#	    print "           $trans_5\n" if $trans_5;
	    print "     : $date\n";
	    print '     : ' . $url . $dir . "$orig_doc.$ext\n";
	    print "\n";
	    $prevline = '';
	    next;
	} else {
	    $doc =~ s,/index$,,; # DocBook
	    $doc =~ s,.*/,,;

	    my $title    = get_ent($H, $doc, "TITL");
	    unless ($title) {
		$prevline = '';
		next;
	    }
	    my $name     = get_ent($H, $doc, "NAME");
	    my $cont     = get_ent($H, $doc, "CONT");
	    my $kind     = get_ent($H, $doc, "KIND");
	    my $author   = get_ent($H, $doc, "AUTH");
	    my $trans_1  = get_ent($H, $doc, "TRNS");
	    my $trans_2  = get_ent($H, $doc, "TRN2");
	    my $trans_3  = get_ent($H, $doc, "TRN3");
	    my $trans_4  = get_ent($H, $doc, "TRN4");
	    my $trans_5  = get_ent($H, $doc, "TRN5");
	    my $dir;
	    if ($contrib{$kind}) {
		$orig_doc = $doc;
		$dir = '/contrib/'. $kind . '/';
	    } else {
		$dir = '/JFdocs/';
	    }

	    print " * $title";
	    if ($stat eq "NEW") {
		print " [New]\n";
	    }else {
		print " [Updated]\n";
	    }
	    print "     ά: $cont\n";
	    print "     : $author\n";
	    print "     : $trans_1\n" if $trans_1;
	    print "           $trans_2\n" if $trans_2;
	    print "           $trans_3\n" if $trans_3;
	    print "           $trans_4\n" if $trans_4;
	    print "           $trans_5\n" if $trans_5;
	    print "     : $date\n";
	    print '     : ' . $url . $dir . "$orig_doc.$ext\n";
	    print "\n";
	    $prevline = '';
	    next;
	}
    }
    
    if (/^\s*_(NEW|UPD)_DOC\((.*)\.(html|txt),(\d+\/\d+\/\d+),/) {
	$i++;
	last if $i > $maxitems;
	$stat = $1;
	$doc  = $2;
	$ext  = $3;
	$date = $4;
	$prevline = $_ if (calc_date($4, $now, $sec)) or ($i <= $minitems);
	next;
    }
    
}
close N;

sub get_kdoc_ent {
    my ($kdoc_info, $key) = @_;
    my $data;
    local $_;

    return unless open(INFO, $kdoc_info);
    while (<INFO>) {
	if (/^$key: (.+)$/) {
	    $data = $1;
	    jcode::convert(\$data, 'euc');
	    last;
	}
    }
    close INFO;
    return $data;
}
       
sub calc_date {
    my ($d, $now, $sec) = @_;
    my @p = split(/\//, $d);
    foreach (@p) {
	s/^0//;
    }
    my $t = timelocal(0, 0, 0, $p[2], $p[1]-1, $p[0]-1900);
    return 1 if $now - $t < $sec;
    return 0;
}
