#!/usr/bin/perl
# $Id: categ_num.pl,v 1.6 2004/01/19 11:21:40 mdk Exp $
#
# index.html ˤ륫ƥʸꥹȤؤΥ󥯤
# ʸοϤޤ

use strict;
use vars qw(%opts);
use DB_File;
use Getopt::Std;
use Time::Local;
use lib ('../bin');		# jfadmlib.pm Τǥ쥯ȥ
use jfadmlib;

getopts('c:d:', \%opts);

my $database = $opts{'d'};
my $category = $opts{'c'};

#
# tie database object to hash, and lock it.
#
my ($H, %index);
$H = tie(%index, 'DB_File', $database, O_RDONLY, 0644, $DB_BTREE) or die;

my $i = 0;
my $new = 0;

foreach my $key (keys %index) {
    next unless $key =~ /\@\@ITEM$/;
    next unless ($category eq 'all') or ($index{$key} =~ /^$category$/);
    
    $i++;
    my ($name, $dummy) = split('@@', $key);
    my $JDAT = get_ent($H, $name, 'JDAT');
    my $passed_time;
    if ($JDAT) {
	my $date = $JDAT;
	if ($date =~ /^\d+$/) {
	    $date = $date . '/01/01';
	} elsif ($date =~ /^\d+\/\d+$/) {
	    $date = $date . '/01';
	}

	$date =~ /(\d+)\/(\d+)\/(\d+)/;
	my ($year, $month, $mday) = ($1, $2, $3);
	$year += 1900 if $year < 1900;
	$month = 1 if $month == 0;
	$mday = 1 if $mday == 0;
	$passed_time = time - timelocal(0, 0, 0, $mday, $month-1, $year-1900);
    } else {
	$passed_time = 60*60*24*365; # dummy
    }
    $new = 1 if $passed_time < 60*60*24*31;
}

print "($i)";
if ($new and ($category ne 'all')) {
    print "\n        <span class=\"new\">new</span>";
}

untie %index;
exit;
