#!/usr/bin/perl
#
# $Id: kdoc-in-progress.pl,v 1.16 2008/10/28 14:01:52 mdk Exp $
#
# kernel docs ͽɽ륹ץȡ()
#
use strict;

##########################################################
#
#

if (@ARGV != 3) {die "Wrong argument count.\n"};

my $VER_LIST = $ARGV[0];
my $RSV_LIST = $ARGV[1];
my $KDOC_DIR = $ARGV[2];

my %status_mark = (
     'ng' => '',
     'ok' => '',
     'good' => '',

     'reserved' => '',
     'draft' => '');

my @exclusion_dir = (
     'ja_JP',
     'ko_KR',
     'zh_CN');

my @exclusion_list = (
    'Configure.help',
    '.gitignore',
    'DocBook/.gitignore',
    'DocBook/dvb/.gitignore',
    'DocBook/v4l/.gitignore',
    'accounting/.gitignore',
    'auxdisplay/.gitignore',
    'connector/.gitignore',
    'ia64/.gitignore',
    'lguest/.gitignore',
    'networking/.gitignore',
    'networking/timestamping/.gitignore',
    'pcmcia/.gitignore',
    'spi/.gitignore',
    'video4linux/.gitignore',
    'vm/.gitignore',
    'watchdog/src/.gitignore',
    'DocBook/Makefile',
    'DocBook/stylesheet.xsl',
    'DocBook/parport-multi.fig',
    'DocBook/parport-share.fig',
    'DocBook/parport-structure.fig',
    'DocBook/procfs_example.c',
    'input/interactive.fig',
    'input/shape.fig',
    'dontdiff',
    'logo.gif',
    'networking/ip_masq/ip_masq-API-ex.c');

##########################################################

my %kdoc = &get_version_status($VER_LIST);

my %rl = &get_reserved_status($RSV_LIST);

open IL, "find $KDOC_DIR -name \"*.info\" |";
while (<IL>){
    chomp;
    my @info = &get_info_status($_);
    my $name = $info[0];
    my $bver = $info[1];
    my $tdat = $info[2];

    ${$kdoc{$name}}{t_ver} = $bver;
    ${$kdoc{$name}}{tdate} = $tdat;
}

foreach my $n (sort keys %kdoc) {
    foreach my $e (@exclusion_dir) {
	if ($n =~ /^$e/) {
	    delete $kdoc{$n};
	}
    }
}

foreach my $n (@exclusion_list) {
    delete $kdoc{$n};
}

print " ̾                                                 ǿ        \n";
print "----------------------------------------------------  ------  --------  ---------- --\n";
foreach my $n (sort keys %kdoc){
    my $o_ver = ${$kdoc{$n}}{o_ver};
    my $t_ver = ${$kdoc{$n}}{t_ver};
    my $date  = ${$kdoc{$n}}{tdate};

    my $wdate = ${$rl{$n}}{date};
    my $wstat = lc(${$rl{$n}}{stat});
    my $trans = ${$rl{$n}}{trans};

    my $smark = $status_mark{ng};

    if ($t_ver ne undef) {
        if (&cmp_version($o_ver, $t_ver) <= 0) {
            $smark = $status_mark{good};
	} else {
	    $smark = $status_mark{ok};
        }
    }

    if ($smark ne $status_mark{good}){
	if ($wstat =~ /^reserved/) {
	    $smark = $status_mark{reserved};
	    $date = $wdate;
	} elsif ($wstat =~ /^draft/) {
	    $smark = $status_mark{draft};
	    $date = $wdate;
	}
    }

    printf("%-54s%-8s%-10s%-11s%2s\n", $n, $o_ver, $t_ver, $date, $smark);
#    if ($trans ne undef){printf("%63s\n", $trans);}
}

exit;

##########################################################
# subroutines
#
sub get_version_status {
#
# СꥹȤɤ߹ǥϥåؤΥϥåä֤
#
    my $VER_LIST = $_[0];
    my (%kdoc, $version, $name);
    open VL, $VER_LIST or die "cannot open $VER_LIST\n";
    while (<VL>){
	chomp;
	if (m/^#/) {next};
	($version, $name) = split;
	${$kdoc{$name}}{o_ver} = $version;
    }
    close VL;
    return %kdoc;
}

sub get_reserved_status {
#
# ͽꥹȤɤ߹ǡϥåؤΥϥå֤
#
  my $RESERVE_INDEX = $_[0];
  my (%rl, $name);

  open RES, $RESERVE_INDEX  or die "cant open $RESERVE_INDEX";
  while (<RES>) {
    chomp;
    if (/^$/ && $name) {
      $name = "";
      next;
    }
    if (/^NAME:\s*(.*)$/) {
      $name = $1;
      $name =~ s/\s*$//; next;
    }
    if ($name && /^TRNS:\s*(.*)$/) {
      ${$rl{$name}}{trans} = $1;
      ${$rl{$name}}{trans} =~ s/\s*$//; next;
    }
    if ($name && /^PDAT:\s*(.*)$/) {
      ${$rl{$name}}{date} = $1;
      ${$rl{$name}}{date} =~ s/\s*$//; next;
    }
    if ($name && /^NOTE:\s*(.*)$/) {
      ${$rl{$name}}{note} = $1;
      ${$rl{$name}}{note} =~ s/\s*$//; next;
    }
    if ($name && /^STAT:\s*(.*)\s*$/) {
      ${$rl{$name}}{stat} = $1;
      ${$rl{$name}}{stat} =~ s/\s*$//; next;
    }
  }
  close RES;
  return %rl;
}

sub get_info_status{
#
# info եʤ (ե̾, С, ) ֤
#
    my $INFOFILE = $_[0];
    my ($name, $bver, $tdat);

    open INFO, $INFOFILE or die "cannot open $INFOFILE\n";
    while(<INFO>){
	chomp;
	if (/^NAME:\s*(.*)$/) {
	    $name = $1;
	    $name =~ s/\s*$//; next;
	}
	if (/^BVER:\s*(.*)$/) {
	    $bver = $1;
	    $bver =~ s/\s*$//; next;
	}
	if (/^JDAT:\s*(.*)$/) {
	    $tdat = $1;
	    $tdat =~ s/\s*$//; next;
	}
    }
    close INFO;
    return ($name, $bver, $tdat);
}

sub cmp_version{
#
# СӴؿ $_[0] <=> $_[1] ˤä -1,0,1
#
    (my $a_major, my $a_minor, my $a_patch) = split /\./, $_[0];
    (my $b_major, my $b_minor, my $b_patch) = split /\./, $_[1];
    $a_major <=> $b_major || $a_minor <=> $b_minor || $a_patch <=> $b_patch;
}
