##
## Japanese Version Copyright (c) 2021 Linux JM project
##         all rights reserved.
##

.PHONY: init gencopyright
init: translation_list gencopyright
translation_list: $(path_po_sources)
	@if test ! -f $@; then \
	  for p in $(RELEASEFILES); do \
	    echo -n "▲:$(PACKAGE_NAME):$(VERSION):0000/00/00:" >> $@ && \
            echo -n $$p | sed -e "s/^man[0-9n]\/\(.*\)\.\([0-9n]\)/\1:\2/" >> $@ &&\
	    echo    ":0000/00/00::$(AUTHOR_EMAIL):$(AUTHOR_NAME):" >> $@; \
	  done \
	fi
gencopyright:
	@mkdir -p po4a/add_ja/copyright
	@cd po4a/add_ja/copyright && \
	for p in $(RELEASEFILES); do \
	  echo "PO4A-HEADER: mode=before; position=^\\.TH"   > `echo $$p | sed -e "s|^man[0-9n]/||" -e "s/$$/.txt/"` ; \
	  echo ".\\\""                                       >>`echo $$p | sed -e "s|^man[0-9n]/||" -e "s/$$/.txt/"` ; \
	  echo ".\\\" Translated 0000-00-00 00:00"           >>`echo $$p | sed -e "s|^man[0-9n]/||" -e "s/$$/.txt/"` ; \
	  echo ".\\\"    by $(AUTHOR_NAME) <$(AUTHOR_EMAIL)>">>`echo $$p | sed -e "s|^man[0-9n]/||" -e "s/$$/.txt/"` ; \
	  echo ".\\\""                                       >>`echo $$p | sed -e "s|^man[0-9n]/||" -e "s/$$/.txt/"` ; \
	done

.PHONY: stat
stat:
	@for l in $(path_po_sources); do \
	  echo -n "$$l: "; \
	  $(MSGFMT) --statistics -o /dev/null $$l; \
	done

.PHONY: releasedir release
releasedir: $(path_man1_sources)
	@cd release && tar cf - . | gzip > /tmp/release.tar.gz
	@mkdir -p man-pages-ja-$(PACKAGE_NAME)-$(VERSION)
	@tar xf /tmp/release.tar.gz -C man-pages-ja-$(PACKAGE_NAME)-$(VERSION)
	@rm -f /tmp/release.tar.gz

release: man-pages-ja-$(PACKAGE_NAME)-$(VERSION).tar.gz
man-pages-ja-$(PACKAGE_NAME)-$(VERSION).tar.gz: releasedir
	@tar cf - man-pages-ja-$(PACKAGE_NAME)-$(VERSION) > $@
	@rm -fr man-pages-ja-$(PACKAGE_NAME)-$(VERSION)

.PHONY: distclean
distclean:: clean
	rm -f man-pages-ja-$(PACKAGE_NAME)-$(VERSION).tar.gz
