dnl
dnl Japanese Version Copyright (c) 2021 Linux JM project
dnl         all rights reserved.
dnl

dnl
dnl To specify the original man directory
dnl
AC_DEFUN([AC_CHECK_ORIGINAL_MAN_DIR],[
  AC_MSG_CHECKING([for the original man directory])
  AC_ARG_WITH(origmandir,
    AS_HELP_STRING([--with-origmandir=DIR],
        [Path to the original man directory]),
      [ORIGMANDIR="$withval"])
  if test "x${ORIGMANDIR}" = "x"; then
    ORIGMANDIR=original
    AC_MSG_RESULT([not specified.])
    AC_MSG_NOTICE(['original' subdir will be used for the original man dir.])
  else
    AC_MSG_RESULT([specified])
  fi
  AC_MSG_CHECKING([for man file $1])
  if test ! -f "${ORIGMANDIR}/$1"; then
    AC_MSG_RESULT([$1 not found])
    AC_MSG_ERROR([$1 must be exist in '${ORIGMANDIR}' dir.])
  else
    AC_MSG_RESULT([$1 found])
  fi
  AC_SUBST(ORIGMANDIR)
  if test "${ORIGMANDIR}" = "original"; then
    ORIGNOTCOPY=1
  else
    ORIGNOTCOPY=0
  fi
  AC_SUBST(ORIGNOTCOPY)
  EXIST_MANSUBDIR=
  if test "`(echo $1 | grep '/')`"; then
    EXIST_MANSUBDIR=1
  fi
  AC_SUBST(EXIST_MANSUBDIR)
])

dnl
dnl To specify author email
dnl
AC_DEFUN([AC_CHECK_AUTHOR_EMAIL],[
  AC_MSG_CHECKING([for author email])
  AC_ARG_WITH(author-email,
    AS_HELP_STRING([--with-author-email=string],
        [Author email to set in po file]),
      [AUTHOR_EMAIL="$withval"])
  if test "x${AUTHOR_EMAIL}" = "x"; then
    AC_MSG_RESULT([not specified, to be blank.])
  else
    AC_MSG_RESULT([specified])
  fi
  AC_SUBST(AUTHOR_EMAIL)
])

dnl
dnl To specify author name
dnl
AC_DEFUN([AC_CHECK_AUTHOR_NAME],[
  AC_MSG_CHECKING([for author name])
  AC_ARG_WITH(author-name,
    AS_HELP_STRING([--with-author-name=string],
        [Author name to set in po file]),
      [AUTHOR_NAME="$withval"])
  if test "x${AUTHOR_NAME}" = "x"; then
    AC_MSG_RESULT([not specified, to be blank.])
  else
    AC_MSG_RESULT([specified])
  fi
  AC_SUBST(AUTHOR_NAME)
])

dnl
dnl To specify author name
dnl
AC_DEFUN([AC_WITH_DRAFT],[
  AC_MSG_CHECKING([for draft page to use])
  AC_ARG_WITH(draft,
    AS_HELP_STRING([--with-draft=[yes|no]],
        [Whether to use draft or not]),
      [DRAFT="$withval"])
  case "${DRAFT}" in
    "")    DRAFT=yes ;;
    "yes") DRAFT=yes ;;
    "no")  DRAFT=no ;;
    *)     AC_MSG_ERROR([Illegal value for --with-draft]) ;;
  esac
  AC_MSG_RESULT([${DRAFT}])
  AC_SUBST(DRAFT)
])
