/*
 * cp932.java
 * Copyright (c) 2008 kbinani
 *
 * This file is part of jp.sourceforge.lipsync.bocoree
 *
 * jp.sourceforge.lipsync.bocoree is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * jp.sourceforge.lipsync.bocoree is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package jp.sourceforge.lipsync.bocoree;

import java.util.*;
import java.nio.charset.*;

public class cp932 {
    //private static HashMap _DICT = new HashMap();
    private static boolean m_initialized = false;
    private static boolean m_cp932_available = false;
    //private static Charset m_cp932 = null;
    private static String s_sjis = "Shift_JIS";

    private static int attatchKey( int key ) {
        if ( cp932_a.getMinKey() <= key && key <= cp932_a.getMaxKey() ) {
            return cp932_a.get( key );
        } else if ( cp932_b.getMinKey() <= key && key <= cp932_b.getMaxKey() ) {
            return cp932_b.get( key );
        } else if ( cp932_c.getMinKey() <= key && key <= cp932_c.getMaxKey() ) {
            return cp932_c.get( key );
        } else {
            return -1;
        }
    }

    private static void init() {
        m_cp932_available = Charset.isSupported( "Shift_JIS" );
        m_initialized = true;
    }

    public static byte[] convert( String str ) {
        if ( !m_initialized ) {
            init();
        }
        if ( m_cp932_available ) {
            byte[] ret;
            try{
                ret = str.getBytes( s_sjis );
            }catch( Exception e ){
                ret = new byte[0];
            }
            return ret;
        } else {
            char[] arr = str.toCharArray();
            ArrayList list = new ArrayList();
            for ( int i = 0; i < arr.length; i++ ) {
                int att = attatchKey( arr[i] );
                if ( att >= 0 ) {
                    if ( att > 0xff ) {
                        byte b1 = (byte) (att >> 8);
                        byte b2 = (byte) (att - (b1 << 8));
                        list.add( b1 );
                        list.add( b2 );
                    } else {
                        list.add( (byte) att );
                    }
                } else {
                    list.add( 0x63 );
                }
            }
            byte[] ret = new byte[list.size()];
            for ( int i = 0; i < list.size(); i++ ) {
                Integer value = (Integer) list.get( i );
                ret[i] = (byte) value.intValue();
            }
            return ret;
        }
    }

    public static String convert( byte[] dat ) {
        if ( !m_initialized ) {
            init();
        }
        if ( m_cp932_available ) {
            String ret;
            try{
                ret = new String( dat, s_sjis );
            }catch( Exception e ){
                ret = "";
            }
            return ret;
        } else {
            StringBuilder sb = new StringBuilder();
            /*int i = 0;
            while ( i < dat.length ) {
                int b1 = dat[i];
                boolean found = false;
                for ( Iterator keys = _DICT.keySet().iterator(); keys.hasNext();) {
                    int key = ((Integer) keys.next()).intValue();
                    int test = (Integer) _DICT.get( key );
                    if ( b1 == test ) {
                        found = true;
                        char ch = (char) key;
                        sb.append( ch + "" );
                        break;
                    }
                }
                i++;
                if ( !found && i < dat.length ) {
                    int b2 = (dat[i - 1] << 8) + dat[i];
                    for ( Iterator keys = _DICT.keySet().iterator(); keys.hasNext();) {
                        Integer key = (Integer) keys.next();
                        int test = ((Integer) _DICT.get( key )).intValue();
                        if ( test == b2 ) {
                            int ik = key.intValue();
                            char ch = (char) ik;
                            sb.append( ch + "" );
                            break;
                        }
                    }
                    i++;
                }
            }*/
            return sb.toString();
        }
    }

}
