﻿/*
 * Winker.cs
 * Copyright (c) 2007-2010 kbinani
 *
 * This file is part of LipSync.
 *
 * LipSync is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * LipSync is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Drawing;
using System.Windows.Forms;

using Boare.Lib.AppUtil;

namespace LipSync {

    public partial class Winker : Form, IMultiLanguageControl {
        private string m_closedeye;
        private string m_in_between;
        public bool Randomize;
        private float m_winkInterval;
        private int m_close_frames = 3;
        private float m_forced_begin;
        private float m_forced_end;
        private float m_max_end;

        public Winker( string[] titles, float total_sec ) {
            InitializeComponent();
            ApplyLanguage();
            ApplyFont( AppManager.Config.Font.GetFont() );
            comboBox1.Items.Clear();
            comboBox2.Items.Clear();
            for ( int i = 0; i < titles.Length; i++ ) {
                comboBox1.Items.Add( titles[i] );
                comboBox2.Items.Add( titles[i] );
            }
            m_closedeye = "";
            m_in_between = "";
            m_forced_begin = 0f;
            m_forced_end = total_sec;
            m_max_end = total_sec;
            txtForceBegin.Text = m_forced_begin.ToString();
            txtForceEnd.Text = m_forced_end.ToString();
            Randomize = false;
        }

        public void ApplyFont( Font font ) {
            this.Font = font;
            foreach ( Control c in this.Controls ) {
                Boare.Lib.AppUtil.Util.applyFontRecurse( c, font );
            }
        }

        public void ApplyLanguage() {
            this.btnCancel.Text = _( "Cancel" );
            this.btnOK.Text = _( "OK" );
            this.label1.Text = _( "Wink interval (sec)" );
            this.checkBox1.Text = _( "Randomize" );
            this.label2.Text = _( "Closed Eye" );
            this.label3.Text = _( "In-between Image" );
            this.label4.Text = _( "Eye-closing frames" );
            this.Text = _( "Generate wink" );
            this.groupBox1.Text = _( "Set image" );
            this.checkForceBegin.Text = _( "Limit start time" );
            this.checkForceEnd.Text = _( "Limit end time" );
        }

        private static string _( string s ) {
            return Messaging.getMessage( s );
        }
        
        public float WinkInterval {
            get {
                return m_winkInterval;
            }
        }

        /// <summary>
        /// 閉じ目用画像のタイトル
        /// </summary>
        public string ClosedEye {
            get {
                return m_closedeye;
            }
        }

        /// <summary>
        /// 閉じ目の中割り用画像のタイトル
        /// </summary>
        public string InBetween {
            get {
                return m_in_between;
            }
        }

        /// <summary>
        /// 目が閉じて表示されるフレーム数
        /// </summary>
        public int CloseFrames {
            get {
                return m_close_frames;
            }
        }

        private void btnOK_Click( object sender, EventArgs e ) {
            try {
                m_winkInterval = float.Parse( textBox1.Text );
                if ( checkForceBegin.Checked ) {
                    m_forced_begin = float.Parse( txtForceBegin.Text );
                }
                if ( checkForceEnd.Checked ) {
                    m_forced_end = float.Parse( txtForceEnd.Text );
                }
                if ( m_forced_begin < 0.0f ) {
                    MessageBox.Show( _( "Invalid value has been entered" ), _( "Error" ), MessageBoxButtons.OK, MessageBoxIcon.Exclamation );
                    this.DialogResult = DialogResult.Cancel;
                } else if ( m_max_end < m_forced_end ) {
                    MessageBox.Show( _( "Invalid value has been entered" ), _( "Error" ), MessageBoxButtons.OK, MessageBoxIcon.Exclamation );
                    this.DialogResult = DialogResult.Cancel;
                } else {
                    this.DialogResult = DialogResult.OK;
                }
            } catch {
                MessageBox.Show( _( "Invalid value has been entered" ), _( "Error" ), MessageBoxButtons.OK, MessageBoxIcon.Exclamation );
                this.DialogResult = DialogResult.Cancel;
            }
            Randomize = checkBox1.Checked;
        }

        private void comboBox1_SelectedIndexChanged( object sender, EventArgs e ) {
            m_closedeye = (string)comboBox1.Items[comboBox1.SelectedIndex];
        }

        private void comboBox2_SelectedIndexChanged( object sender, EventArgs e ) {
            m_in_between = (string)comboBox2.Items[comboBox2.SelectedIndex];
        }

        private void textBox2_TextChanged( object sender, EventArgs e ) {
            int old = m_close_frames;
            try {
                m_close_frames = int.Parse( textBox2.Text );
            } catch {
                m_close_frames = old;
            }
        }

        private void checkForceBegin_CheckedChanged( object sender, EventArgs e ) {
            txtForceBegin.Enabled = checkForceBegin.Checked;
            if ( txtForceBegin.Enabled ) {
                txtForceBegin.Focus();
            }
        }

        private void checkForceEnd_CheckedChanged( object sender, EventArgs e ) {
            txtForceEnd.Enabled = checkForceEnd.Checked;
            if ( txtForceEnd.Enabled ) {
                txtForceEnd.Focus();
            }
        }

        public bool BeginForced {
            get {
                return checkForceBegin.Checked;
            }
        }

        public bool EndForced {
            get {
                return checkForceEnd.Checked;
            }
        }

        public float ForcedBegin {
            get {
                return m_forced_begin;
            }
            set {
                m_forced_begin = value;
            }
        }

        public float ForcedEnd {
            get {
                return m_forced_end;
            }
            set {
                m_forced_end = value;
            }
        }
    }

}
