﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Background {
    public partial class entry_config : Form {
        EntryConfig m_entry_config;
        public entry_config( EntryConfig config ) {
            InitializeComponent();
            m_entry_config = config;
            txtFile.Text = m_entry_config.File;
            txtX.Text = m_entry_config.X.ToString();
            txtY.Text = m_entry_config.Y.ToString();
            txtScale.Text = m_entry_config.Scale.ToString();
            chkFadeIn.Checked = m_entry_config.FadeIn;
            chkFadeOut.Checked = m_entry_config.FadeOut;
            txtFadeInRatio.Text = m_entry_config.FadeInRatio.ToString();
            txtFadeOutRatio.Text = m_entry_config.FadeOutRatio.ToString();
        }

        private void btnFile_Click( object sender, EventArgs e ) {
            if ( dialogImage.ShowDialog() == DialogResult.OK ) {
                txtFile.Text = dialogImage.FileName;
            }
        }


        private void btnOK_Click( object sender, EventArgs e ) {
            EntryConfig old = m_entry_config;
            try {
                m_entry_config.File = txtFile.Text;
                m_entry_config.X = int.Parse( txtX.Text );
                m_entry_config.Y = int.Parse( txtY.Text );
                m_entry_config.Scale = float.Parse( txtScale.Text );
                m_entry_config.FadeIn = chkFadeIn.Checked;
                m_entry_config.FadeOut = chkFadeOut.Checked;
                m_entry_config.FadeInRatio = float.Parse( txtFadeInRatio.Text );
                m_entry_config.FadeOutRatio = float.Parse( txtFadeOutRatio.Text );
                if ( m_entry_config.FadeInRatio <= 0f ) {
                    m_entry_config.FadeIn = false;
                    m_entry_config.FadeInRatio = 2f;
                }
                if ( m_entry_config.FadeOutRatio <= 0f ) {
                    m_entry_config.FadeOut = false;
                    m_entry_config.FadeOutRatio = 2f;
                }
                this.DialogResult = DialogResult.OK;
            } catch {
                m_entry_config = old;
                this.DialogResult = DialogResult.Cancel;
            }
        }


        public EntryConfig Config {
            get {
                return m_entry_config;
            }
        }

        
        private void chkFadeIn_CheckedChanged( object sender, EventArgs e ) {
            txtFadeInRatio.Enabled = chkFadeIn.Checked;
        }


        private void chkFadeOut_CheckedChanged( object sender, EventArgs e ) {
            txtFadeOutRatio.Enabled = chkFadeOut.Checked;
        }
    }
}