/*
 * VsqEvent.java
 * Copyright (c) 2008 kbinani
 *
 * This file is part of jp.sourceforge.lipsync.vsq.
 *
 * jp.sourceforge.lipsync.vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * jp.sourceforge.lipsync.vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package jp.sourceforge.lipsync.vsq;

/**
 * vsqファイルのメタテキスト内に記述されるイベント。
 */
public class VsqEvent implements Comparable<VsqEvent>, Cloneable {
    //int m_internal_id;
    /**
     * 内部で使用するインスタンス固有のID<br>
     * for furutre implement:<pre>
     *    public property int InternalID {
     *       get {
     *            return m_internal_id;
     *       }
     *       set {
     *           m_internal_id = value;
     *       }
     *   };</pre>
     */
    public int InternalID;
    //int m_clock;
    public int Clock;
    //VsqID m_id;
    public VsqID ID;

    /**
     * このオブジェクトのコピーを作成します
     * @returns>
     */
    public Object clone() {
        VsqEvent ret = new VsqEvent( Clock, ID );
        ret.InternalID = InternalID;
        return ret;
    }


    /* // <summary>
    /// このイベントが発生するクロック。
    /// </summary>
    public property int Clock {
    get {
    return m_clock;
    }
    set {
    m_clock = value;
    }
    };*/

    /* // <summary>
    /// 発生するイベントの内容を表したID
    /// </summary>
    public property VsqID ID {
    get {
    return m_id;
    }
    set {
    m_id = value;
    }
    };*/
    public int compareTo( VsqEvent item ) {
        int ret = this.Clock - item.Clock;
        if ( ret == 0 ) {
            if ( this.ID != null && item.ID != null ) {
                if ( this.ID == item.ID ) {
                    return 0;
                } else {
                    if ( this.ID.type == VsqIDType.Singer ) {
                        return -1;
                    } else if ( item.ID.type == VsqIDType.Anote ) {
                        return 1;
                    }
                }
            } else {
                return ret;
            }
        } else {
            return ret;
        }
        return 0;
    }

    public VsqEvent( String line ) {
        String[] spl = line.split( "=" );
        Clock = Integer.parseInt( spl[0] );
        if ( spl[1].equals( "EOS" ) ) {
            ID = VsqID.EOS;
        }
    }

    public VsqEvent( int clock, VsqID id /*, int internal_id*/ ) {
        Clock = clock;
        ID = (VsqID)id.clone();
        //InternalID = internal_id;
        InternalID = 0;
    }

}
