﻿/*
 * BugReport.cs
 * Copyright (c) 2007-2010 kbinani
 *
 * This file is part of LipSync.
 *
 * LipSync is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * LipSync is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Windows.Forms;

namespace LipSync {

    public partial class BugReport : Form {
        public BugReport() {
            InitializeComponent();
            string runtime_version = System.Runtime.InteropServices.RuntimeEnvironment.GetSystemVersion();
            textBox1.Text = "[     OS     ]:" + OsVersion() + Environment.NewLine +
                            "[.NET runtime]:" + runtime_version + Environment.NewLine +
                            "[   LipSync  ]:v" + AppManager.VERSION;
        }
        
        private static string OsVersion() {
            OperatingSystem os = System.Environment.OSVersion;
            string version = "(" + os.Version.ToString() + ")";
            switch ( os.Platform ) {
                case PlatformID.Win32Windows:
                    if ( os.Version.Major >= 4 ) {
                        switch ( os.Version.Minor ) {
                            case 0:
                                return "Windows 95" + version;
                            case 10:
                                return "Windows 98" + version;
                            case 90:
                                return "Windows Me" + version;
                        }
                    }
                    break;
                case PlatformID.Win32NT:
                    switch ( os.Version.Major ) {
                        case 3:
                            switch ( os.Version.Minor ) {
                                case 0:
                                    return "Windows NT 3" + version;
                                case 1:
                                    return "Windows NT 3.1" + version;
                                case 5:
                                    return "Windows NT 3.5" + version;
                                case 51:
                                    return "Windows NT 3.51" + version;
                            }
                            break;
                        case 4:
                            if ( os.Version.Minor == 0 ) {
                                return "Windows NT 4.0" + version;
                            }
                            break;
                        case 5:
                            if ( os.Version.Minor == 0 ) {
                                return "Windows 2000" + version;
                            } else if ( os.Version.Minor == 1 ) {
                                return "Windows XP" + version;
                            }
                            break;
                        case 6:
                            if ( os.Version.Minor == 0 ) {
                                return "Windows Vista" + version;
                            }
                            break;
                    }
                    break;
                case PlatformID.Win32S:
                    return "Win32s" + version;
            }
            return os.Platform.ToString() + version;
        }
    }

}
