﻿/*
 * ScoreUnit.cs
 * Copyright (c) 2007-2010 kbinani
 *
 * This file is part of LipSync.
 *
 * LipSync is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * LipSync is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Collections.Generic;

using Boare.Lib.Vsq;

namespace LipSync {

    /// <summary>
    /// 楽譜の一部分を取り扱います。ただし単一の拍子で表現できる部分のみ
    /// </summary>
    [Serializable, Obsolete]
    public class ScoreUnit {
        /// <summary>
        /// このインスタンスが表す楽譜の、曲頭からの時刻を表します
        /// </summary>
        public float Start;
        /// <summary>
        /// 拍子の分子
        /// </summary>
        public int Numerator;
        /// <summary>
        /// 拍子の分母
        /// </summary>
        public int Denominator;
        /// <summary>
        /// テンポの変更情報を格納したリスト
        /// </summary>
        public List<TempoTableEntry> TempoList;

        public ScoreUnit() {
            Start = 0f;
            Numerator = 4;
            Denominator = 4;
            TempoList = new List<TempoTableEntry>();
            TempoList.Add( new TempoTableEntry( 0, 480000, 0.0 ) );
        }
    }

}
