/*
 * Settings.cs
 * Copyright (c) 2007-2010 kbinani
 *
 * This file is part of LipSync.
 *
 * LipSync is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * LipSync is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Runtime.Serialization;

using Boare.Lib.AppUtil;
using Boare.Lib.Vsq;

namespace LipSync {

    [Serializable]
    public class Settings : IDisposable/*, ICloneable*/ {
        const double tpq_sec = 480000000.0;

        public TimeTableGroup m_group_vsq;                  //ok
        public List<TimeTableGroup> m_groups_character;     //ok
        public TimeTableGroup m_group_another;              //ok
        public TimeTableGroup m_group_plugin;               //ok
        [Obsolete]
        //public float fps = 30.0f;                           //ok
        float fps = 30f;
        public int m_screenWidth;                           //ok
        public int m_screenHeight;                          //ok
        public float m_totalSec = 0.0f;                     //ok
        public Size m_movieSize; // = new Size( 512, 384 );     //ok
        public List<PluginConfig> m_plugins_config;         //ok
        public string m_audioFile = "";                     //ok
        [OptionalField]
        public Color CANVAS_BACKGROUND; // = Color.White;       //ok
        [OptionalField, Obsolete]
        public List<Telop> m_telop;                         //ok
        [OptionalField]
        public float REPEAT_START;                          //ok
        [OptionalField]
        public float REPEAT_END;                            //ok
        [OptionalField, Obsolete]//[OptionalField]
        public SortedDictionary<int, Telop> m_telop_ex = new SortedDictionary<int, Telop>();     //OK
        [OptionalField, Obsolete]
        public List<ScoreUnit> m_score_unit;
        [OptionalField, Obsolete]
        public List<TimeSig> m_timesig;
        [OptionalField]
        public List<TimeSigTableEntry> m_timesig_ex;
        [OptionalField]
        public List<TempoTableEntry> m_tempo;
        [OptionalField]
        public int m_base_tempo;
        [OptionalField]
        public uint m_dwRate = 30;
        [OptionalField]
        public uint m_dwScale = 1;
        [NonSerialized]
        private float m_fps_buffer = 30f;
        [NonSerialized]
        public PluginInfo[] m_plugins;
        [OptionalField]
        public List<Telop> m_telop_ex2 = new List<Telop>();

        /// <summary>
        /// 描画順序で格納された描画物のリスト
        /// </summary>
        [NonSerialized]
        public List<ZorderItem> m_zorder = new List<ZorderItem>();
        [NonSerialized]
        public List<Command> m_commands = new List<Command>();
        [NonSerialized]
        public int m_command_position = -1;

        public static string _( string s ) {
            return Messaging.getMessage( s );
        }

        public Settings() {
            m_zorder = new List<ZorderItem>();
            m_commands = new List<Command>();
            m_command_position = -1;
            m_group_vsq = new TimeTableGroup( _( "VSQ Tracks" ), -1, null );
            m_groups_character = new List<TimeTableGroup>();
            m_group_another = new TimeTableGroup( _( "Another images" ), -1, null );
            m_group_plugin = new TimeTableGroup( _( "Plugin" ), -1, null );
            m_telop_ex2 = new List<Telop>();
            m_screenWidth = 512;
            m_screenHeight = 384;
            m_totalSec = 0.0f;
            m_movieSize = new Size( 512, 384 );
            m_plugins_config = new List<PluginConfig>();
            m_audioFile = "";
            CANVAS_BACKGROUND = Color.White;
            //m_telop = new List<Telop>();
            //m_telop_ex = new SortedDictionary<int, Telop>();
            m_telop_ex2 = new List<Telop>();
            m_score_unit = new List<ScoreUnit>();
            m_score_unit.Add( new ScoreUnit() );
            m_timesig_ex = new List<TimeSigTableEntry>();
            m_tempo = new List<TempoTableEntry>();
            m_base_tempo = 480000;
            m_dwRate = 30;
            m_dwScale = 1;
            m_fps_buffer = (float)m_dwRate / (float)m_dwScale;
        }

        [OnSerializing]
        private void onSerializing( StreamingContext sc ) {
            m_telop = null;
            m_telop_ex = null;
        }

        [OnDeserializing]
        private void onDeserializing( StreamingContext sc ) {
            CANVAS_BACKGROUND = Color.White;
            m_telop_ex2 = new List<Telop>();
            REPEAT_START = 0f;
            REPEAT_END = -1f;
            m_score_unit = new List<ScoreUnit>();
            m_dwRate = 0;
            m_dwScale = 0;
        }


        [OnDeserialized]
        void onDeserialized( StreamingContext sc ) {
#if DEBUG
            Console.WriteLine( "Settings.onDeserialized(StreamingContext)" );
#endif
            m_score_unit = new List<ScoreUnit>();
            m_score_unit.Add( new ScoreUnit() );
            if ( m_telop != null ) {
                if ( m_telop_ex2 != null ) {
                    m_telop_ex2.Clear();
                    m_telop_ex2 = null;
                }
                m_telop_ex2 = new List<Telop>();
                for ( int i = 0; i < m_telop.Count; i++ ) {
                    m_telop_ex2.Add( (Telop)m_telop[i].Clone( i ) );
                }
                m_telop.Clear();
                m_telop = null;
            }
            if ( m_telop_ex != null ) {
                if ( m_telop_ex2 != null ) {
                    m_telop_ex2.Clear();
                    m_telop_ex2 = null;
                }
                m_telop_ex2 = new List<Telop>();
                int index = -1;
                foreach ( KeyValuePair<int, Telop> telop in m_telop_ex ) {
                    index++;
                    m_telop_ex2.Add( (Telop)telop.Value.Clone( index ) );
                }
                m_telop_ex.Clear();
                m_telop_ex = null;
            }
            m_commands = new List<Command>();
            m_command_position = -1;
            m_zorder = new List<ZorderItem>();
            if ( m_timesig_ex == null ) {
                m_timesig_ex = new List<TimeSigTableEntry>();
            }
            if ( m_tempo == null ) {
                m_tempo = new List<TempoTableEntry>();
            }
            if ( m_dwRate == 0 ) {
                m_dwScale = 1000;
                m_dwRate = (uint)(fps * m_dwScale);
            }
            m_fps_buffer = (float)m_dwRate / (float)m_dwScale;
#if DEBUG
            Common.DebugWriteLine( "----------" );
            Common.DebugWriteLine( "Settings.onDeserialized(StreamingContext)" );
            for ( int i = 0; i < m_telop_ex2.Count; i++ ) {
                Common.DebugWriteLine( "i=" + i + "; ID=" + m_telop_ex2[i].ID + "; Text=" + m_telop_ex2[i].Text );
            }
            Common.DebugWriteLine( "----------" );
#endif
        }

        public void Dispose() {
            if ( m_group_vsq != null ) {
                m_group_vsq.Dispose();
                m_group_vsq = null;
            }
            if ( m_groups_character != null ) {
                m_groups_character.Clear();
                m_groups_character = null;
            }
            if ( m_group_another != null ) {
                m_group_another.Dispose();
                m_group_another = null;
            }
            if ( m_group_plugin != null ) {
                m_group_plugin.Dispose();
                m_group_plugin = null;
            }
            if ( m_plugins_config != null ) {
                m_plugins_config.Clear();
                m_plugins_config = null;
            }
        }
    }

}
