﻿/*
 * ZorderItem.cs
 * Copyright (c) 2007-2010 kbinani
 *
 * This file is part of LipSync.
 *
 * LipSync is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * LipSync is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;

namespace LipSync {

    public enum ZorderItemType {
        plugin,
        character,
        another,
        telop,
    }

    public class ZorderItem : IComparable<ZorderItem>, ICloneable {
        private string m_name;
        private ZorderItemType m_type;
        private int m_index;
        public float Start;

        public object Clone() {
            return new ZorderItem( this.m_name, this.m_type, this.m_index, this.Start );
        }

        public int CompareTo( ZorderItem item ) {
            if( this.Index > item.Index ){
                return 1;
            } else if ( this.Index < item.Index ) {
                return -1;
            } else {
                return this.Type.CompareTo( item.Type );
            }
        }

        public ZorderItem( string name, ZorderItemType type, int index )
            : this( name, type, index, 0f ) {
        }

        public ZorderItem( string name, ZorderItemType type, int index, float start ) {
            m_name = name;
            m_type = type;
            m_index = index;
            Start = start;
        }

        public string Name {
            get {
                return m_name;
            }
        }

        public ZorderItemType Type {
            get {
                return m_type;
            }
        }

        public int Index {
            get {
                return m_index;
            }
        }
    }

}
