﻿using System;
using Plugin;
using System.Drawing;
using System.Windows.Forms;

public class OverlayImpeller : IPlugin {
    private string m_config;

    /// <summary>
    /// フレームに加工を施す関数
    /// </summary>
    /// <param name="frame">加工の対象</param>
    /// <param name="time">ビデオの先頭からの時刻(秒)</param>
    /// <param name="e_begin">エントリの開始時刻</param>
    /// <param name="e_body">エントリの終了時刻</param>
    /// <param name="e_end">エントリの設定値</param>
    public void Apply( ref Bitmap frame, float time, float e_begin, float e_end, ref string e_body ) {
        double rpm = 12.4;
        int centerx = 144;
        int centery = 144;
        int impeller_diameter = 163;
        int impeller_height_half = 12;
        double theta0 = 0.0;

        double omega = 2.0 * Math.PI / (60.0 / rpm);
        double theta = theta0 + time * omega;
        int current_width = Math.Abs( (int)(impeller_diameter * Math.Cos( theta ) / 2.0) );
        using ( Graphics g = Graphics.FromImage( frame ) ) {
            g.DrawRectangle( new Pen( Color.Black, 2 ), new Rectangle( centerx - current_width, centery - impeller_height_half, current_width * 2, impeller_height_half * 2 ) );
        }
    }

    public void ApplyLanguage( string lang ) {
    }

    /// <summary>
    /// プラグインの名称
    /// </summary>
    public string Name {
        get {
            return "OverlayImpeller";
        }
    }

    /// <summary>
    /// プラグインの簡潔な説明文。
    /// </summary>
    public string Abstract {
        get {
            return "OverlayImpeller";
        }
    }

    /// <summary>
    /// プラグイン用の設定値を格納した文字列を指定します。
    /// </summary>
    /// <returns></returns>
    public string Config {
        get {
            return m_config;
        }
        set {
            m_config = value;
        }
    }

    public DialogResult BaseSetting() {
        return DialogResult.Cancel;
    }

    public DialogResult EntrySetting( ref string entry_setting ) {
        return DialogResult.Cancel;
    }

    public void Render( Graphics g, Size size, float time, string mouth, string Reserved ) {
    }

    public ulong Type {
        get {
            return Constants.LS_NO_EVENT_HANDLER | Constants.LS_ENABLES_ENTRY_SETTING;
        }
    }
}

