/**
 * @file  Thread.h
 * @brief XbhǗNX`.
 *
 * @author JIN
 *
 * Copyright (C) 2004- JIN All rights reserved.
 */
#ifndef THREAD_H_
#define THREAD_H_

#include <boost/utility.hpp>

namespace GenericUtility {

//-----------------------------------------------------------------------------
/**
 * thread ǗNX.
 */
class CThread : boost::noncopyable
{
public:
	CThread();
	~CThread();

	/**
	 * thread C^[tFCX.
	 */
	class Runnable {
	public:
		virtual bool Initialize() = 0;
		virtual DWORD Run() = 0;
		virtual bool Stop() = 0;
	};

	typedef boost::shared_ptr<Runnable> RunnablePtr;
	typedef boost::weak_ptr  <Runnable> RunnableWPtr;

	/**
	 * thread 쐬.
	 */
	bool Create(const RunnablePtr& runnable);
	/**
	 * thread ~Ă邩ǂׂ.
	 */
	bool Peek(DWORD* pdwReturnCode = NULL);
	/**
	 * thread ~.
	 */
	bool Stop(DWORD* pdwReturnCode = NULL);

	/**
	 * thread ֐.
	 */
	static DWORD WINAPI ThreadProc(LPVOID lpParameter);

protected:
	HANDLE m_hThread;
	RunnableWPtr m_runnable;
};

}	// namespace GenericUtility

#endif
