﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;

namespace Aqua877.WinApp.IronLivetube
{
	public partial class CacheManageWindow : Form
	{
		public CacheManageWindow()
		{
			InitializeComponent();

			this.RefreshStatus();
		}

		private void RunGCButton_Click(object sender, EventArgs e)
		{
			GC.Collect();
			this.RefreshStatus();
		}

		private void CleanCachesButton_Click(object sender, EventArgs e)
		{
			var result = MessageBox.Show(
				"キャッシュのクリーンを実行すると、現在キャッシングされているデータがすべて削除されます。\nメモリ使用量は少なくなりますが、現在開発中の機能につき動作が不安定になるおそれがあります。実行しますか？",
				"警告",
				MessageBoxButtons.OKCancel, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button2
			);

			if (result == System.Windows.Forms.DialogResult.OK)
			{
				GlobalValues.CallCleanCaches();
				this.RefreshStatus();
			}
		}

		private void RefreshStatus()
		{
			this.CachingCommentsCountLabel.Text = GlobalValues.CachingComments.ToString();
			this.CachingThumbnailsCountLabel.Text = GlobalValues.CachingThumbnails.ToString();
			this.UsingMemoriesCountLabel.Text = String.Format("{0:f1}KB", (Process.GetCurrentProcess().WorkingSet64 / 1024).ToString());
		}


	}
}
