﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net;
using System.Collections.Specialized;

namespace Aqua877.WinApp.IronLivetube
{
	public class ErrorReportHelper
	{
		public static event Action<bool> ReportExceptionFinished;

		public static void ReportException(Exception ex)
		{
			var connector = new WebClient() { Encoding = Encoding.UTF8 };
			connector.UploadValuesCompleted += (s, e) =>
			{
				if (e.Error != null)
				{
					if (ReportExceptionFinished != null)
					{
						ReportExceptionFinished(false);
					}
				}
				else
				{
					if (ReportExceptionFinished != null)
					{
						ReportExceptionFinished(true);
					}
				}
			};

			connector.UploadValuesAsync(new Uri("http://192.168.1.2/ls_errors/lserr.php"), new NameValueCollection()
			{
				{ "exception", ex.ToString() }
			});
		}
	}
}
