﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Aqua877.WinApp.IronLivetube
{
	public partial class ErrorReportWindow : Form
	{
		private Exception Error;
		public ErrorReportWindow(Exception error)
		{
			this.Error = error;
			InitializeComponent();
		}

		private void ReportErrorButton_Click(object sender, EventArgs e)
		{
			ErrorReportHelper.ReportExceptionFinished += ret =>
			{
				if (ret)
				{
					MessageBox.Show("エラー報告は完了しました。ご協力ありがとうございます。", "エラー報告完了", MessageBoxButtons.OK, MessageBoxIcon.Information);
				}
				else
				{
					MessageBox.Show("エラー報告は正しく完了しませんでした。", "エラー報告失敗", MessageBoxButtons.OK, MessageBoxIcon.Error);
				}
				this.Close();
			};

			ErrorReportHelper.ReportException(this.Error);
		}

		private void CloseButton_Click(object sender, EventArgs e)
		{
			this.Close();
		}

		private void ErrorReport_FormClosing(object sender, FormClosingEventArgs e)
		{
			if (this.RestartIronLivetubeCheckBox.Checked)
			{
				GlobalValues.RestartProgramTrigger = true;
			}
		}
	}
}
