﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Text.RegularExpressions;

namespace Aqua877.WinApp.IronLivetube
{
	public partial class OpenLiveFromURLWindow : Form
	{
		public OpenLiveFromURLWindow()
		{
			InitializeComponent();
		}

		private void OpenLiveButton_Click(object sender, EventArgs e)
		{
			if (this.LiveUrlTextBox.Text == "")
			{
				this.ErrorMessageTextBox.Visible = true;
				this.ErrorMessageTextBox.Text = "    URLが入力されていません。";
				return;
			}

			Uri _ = null;
			if (!Uri.TryCreate(this.LiveUrlTextBox.Text, UriKind.Absolute, out _))
			{
				this.ErrorMessageTextBox.Visible = true;
				this.ErrorMessageTextBox.Text = "    正しい形式のURLを入力してください";
			}
			else if (!Regex.IsMatch(this.LiveUrlTextBox.Text, GlobalValues.LiveUrlPattern))
			{
				this.ErrorMessageTextBox.Visible = true;
				this.ErrorMessageTextBox.Text = "    Livetube配信へのURLの形式が正しくありません。";
			}
			else
			{
				this.Tag = this.LiveUrlTextBox.Text;
				this.DialogResult = System.Windows.Forms.DialogResult.OK;
				this.Close();
			}
		}
	}
}
