/**
 * Magic3 CKEditorプラグイン
 *
 * JavaScript 1.5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2013 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: linkinfo.js 5938 2013-04-16 23:20:50Z fishbone $
 * @link       http://www.magic3.org
 */
CKEDITOR.dialog.add( 'linkinfoDialog', function( editor ) {
	return {

		// Basic properties of the dialog window: title, minimum size.
		title: editor.lang.linkinfo.title,
		minWidth: 400,
		minHeight: 200,

		// Dialog window contents definition.
		contents: [
			{
				// Definition of the Basic Settings dialog tab (page).
				id: 'tab-basic',
				label: 'Basic Settings',

				// The tab contents.
				elements: [
					{
						type : 'select',
						id : 'style',
						label : 'Style',
						items : [
							[ '<none>', '' ],
							[ 'Bold', 'b' ],
							[ 'Underline', 'u' ],
							[ 'Italics', 'i' ]
						],
						onLoad : function(){		// 起動時イベント
							var elementId = '#' + this.getInputElement().$.id;
							
							// Ajaxでリンク情報を取得
							m3_ajax_request('', 'task=linkinfo&act=getlink&linktype=content&content_serial=', function(request, retcode, jsondata){		// 正常終了
								if (jsondata.menu_html){
									$(elementId).html(jsondata.menu_html);
								}
							}, function(request){		// 異常終了
								alert('ajax failure!');
							});
						},
						onChange : function( api ){	// 選択値変更時イベント
							m3_ajax_request('', 'task=linkinfo&act=getlink&linktype=content&content_serial=', ajax_success_func, ajax_failure_func);
						},
						setup : function(element){
							alert("setup...");
							
							
/*
							          var element_id = '#' + this.getInputElement().$.id;
        $.ajax({
            type: 'POST',
            url: 'lib/ckeditor/plugins/customExam/utilities/listExams.aspx',
            data: '{"cpID":' + window.parent.$("#cpID").val() + '}',
            contentType: 'application/json; charset=utf-8',
            dataType: 'json',
            async: false,
            success: function(data) {
                $.each(data.DATA, function(index, item) {
                    $(element_id).get(0).options[$(element_id).get(0).options.length] = new Option(item[1], item[0]);
                });
            },
            error:function (xhr, ajaxOptions, thrownError){
                alert(xhr.status);
                alert(thrownError);
            } 
        });
*/
						},
						commit : function( data ){
							data.style = this.getValue();
						}
					},
					{
						// Text input field for the abbreviation title (explanation).
						type: 'text',
						id: 'title',
						label: 'Explanation',
						validate: CKEDITOR.dialog.validate.notEmpty( "Explanation field cannot be empty" )
					}
				]
			}

/*			// Definition of the Advanced Settings dialog tab (page).
			{
				id: 'tab-adv',
				label: 'Advanced Settings',
				elements: [
					{
						// Another text field for the abbr element id.
						type: 'text',
						id: 'id',
						label: 'Id'
					}
				]
			}*/
		],

		// This method is invoked once a user clicks the OK button, confirming the dialog.
		onOk: function() {

			// The context of this function is the dialog object itself.
			// http://docs.ckeditor.com/#!/api/CKEDITOR.dialog
			var dialog = this;

			// Creates a new <abbr> element.
			var abbr = editor.document.createElement( 'abbr' );

			// Set element attribute and text, by getting the defined field values.
			abbr.setAttribute( 'title', dialog.getValueOf( 'tab-basic', 'title' ) );
			abbr.setText( dialog.getValueOf( 'tab-basic', 'abbr' ) );

			// Now get yet another field value, from the advanced tab.
			var id = dialog.getValueOf( 'tab-adv', 'id' );
			if ( id )
				abbr.setAttribute( 'id', id );

			// Finally, inserts the element at the editor caret position.
			editor.insertElement( abbr );
		}
	};
});
