-- *
-- * バージョンアップ用スクリプト
-- *
-- * PHP versions 5
-- *
-- * LICENSE: This source file is licensed under the terms of the GNU General Public License.
-- *
-- * @package    Magic3 Framework
-- * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
-- * @copyright  Copyright 2006-2009 Magic3 Project.
-- * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
-- * @version    SVN: $Id: _tmp.sql 5274 2012-10-10 09:09:44Z fishbone $
-- * @link       http://www.magic3.org
-- *
-- --------------------------------------------------------------------------------------------------
-- バージョンアップ用スクリプト
-- --------------------------------------------------------------------------------------------------

-- コンテンツオプションマスター
DROP TABLE IF EXISTS content_option;
CREATE TABLE content_option (
    op_serial            INT            AUTO_INCREMENT,                              -- レコードシリアル番号
    op_type_id           VARCHAR(20)    DEFAULT ''                    NOT NULL,      -- コンテンツタイプ(「a:c-h」a=アクセスポイント,c=コンテンツタイプ,h=参照方法。「a:」「-h」省略可。)
    op_content_id        VARCHAR(50)    DEFAULT ''                    NOT NULL,      -- コンテンツ識別用のID
    op_history_index     INT            DEFAULT 0                     NOT NULL,      -- 履歴管理用インデックスNo(0～)
    
    op_value             TEXT                                         NOT NULL,      -- 値
    op_create_user_id    INT            DEFAULT 0                     NOT NULL,      -- レコード作成者
    op_create_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- レコード作成日時
    op_update_user_id    INT            DEFAULT 0                     NOT NULL,      -- レコード更新者
    op_update_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- レコード更新日時
    op_deleted           BOOLEAN        DEFAULT false                 NOT NULL,      -- レコード削除状態
    PRIMARY KEY          (op_serial),
    UNIQUE               (op_type_id,   op_content_id, op_history_index)
) TYPE=innodb;

-- *** システムベーステーブル ***
-- クライアントIPアクセス制御マスター
DROP TABLE IF EXISTS _access_ip;
CREATE TABLE _access_ip (
    ai_serial            INT            AUTO_INCREMENT,                              -- レコードシリアル番号
    ai_ip                VARCHAR(40)    DEFAULT ''                    NOT NULL,      -- アクセス元IP(IPv6対応)
    ai_ip_mask           VARCHAR(40)    DEFAULT ''                    NOT NULL,      -- IPマスク値
    ai_access_type       INT            DEFAULT 0                     NOT NULL,      -- アクセス制御タイプ(0=未設定、1=アクセス許可、2=管理機能アクセス許可、-1=アクセス拒否)
    ai_server_id         CHAR(32)       DEFAULT ''                    NOT NULL,      -- サーバ識別ID
    ai_active            BOOLEAN        DEFAULT true                  NOT NULL,      -- 有効かどうか
    ai_active_start_dt   TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- 有効期間(開始)
    ai_active_end_dt     TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- 有効期間(終了)
    ai_ope_log_serial    INT            DEFAULT 0                     NOT NULL,      -- 運用ログシリアル番号
    
    ai_create_user_id    INT            DEFAULT 0                     NOT NULL,      -- レコード作成者
    ai_create_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- レコード作成日時
    PRIMARY KEY          (ai_serial),
    UNIQUE               (ai_ip, ai_ip_mask)
) TYPE=innodb;

-- コンテンツカテゴリマスター
DROP TABLE IF EXISTS content_category;
CREATE TABLE content_category (
    cr_serial            INT            AUTO_INCREMENT,                              -- レコードシリアル番号
    cr_id                INT            DEFAULT 0                     NOT NULL,      -- カテゴリID
    cr_language_id       VARCHAR(2)     DEFAULT ''                    NOT NULL,      -- 言語ID
    cr_history_index     INT            DEFAULT 0                     NOT NULL,      -- 履歴管理用インデックスNo(0～)

    cr_name              VARCHAR(30)    DEFAULT ''                    NOT NULL,      -- カテゴリ名称
    cr_parent_id         INT            DEFAULT 0                     NOT NULL,      -- 親カテゴリID
    cr_sort_order        INT            DEFAULT 0                     NOT NULL,      -- ソート用
    cr_visible           BOOLEAN        DEFAULT true                  NOT NULL,      -- 表示するかどうか

    cr_create_user_id    INT            DEFAULT 0                     NOT NULL,      -- レコード作成者
    cr_create_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- レコード作成日時
    cr_update_user_id    INT            DEFAULT 0                     NOT NULL,      -- レコード更新者
    cr_update_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- レコード更新日時
    cr_deleted           BOOLEAN        DEFAULT false                 NOT NULL,      -- レコード削除状態
    PRIMARY KEY          (cr_serial),
    UNIQUE               (cr_id,        cr_language_id,  cr_history_index)
) TYPE=innodb;

-- コンテンツとコンテンツカテゴリーの対応付けマスター
DROP TABLE IF EXISTS content_with_category;
CREATE TABLE content_with_category (
    cw_serial            INT            AUTO_INCREMENT,                              -- レコードシリアル番号
    cw_content_id        INT            DEFAULT 0                     NOT NULL,      -- コンテンツID
    cw_index             INT            DEFAULT 0                     NOT NULL,      -- インデックス番号(0～)
    cw_category_id       INT            DEFAULT 0                     NOT NULL,      -- カテゴリID
    PRIMARY KEY          (cw_serial),
    UNIQUE               (cw_content_id,  cw_index)
) TYPE=innodb;

-- 内部コンテンツ(検索対象外)マスター
DROP TABLE IF EXISTS _inner_content;
CREATE TABLE _inner_content (
    ic_serial            INT            AUTO_INCREMENT,                              -- レコードシリアル番号
    ic_widget_id         VARCHAR(50)    DEFAULT ''                    NOT NULL,      -- ウィジェットID(ファイル名)
    ic_id                VARCHAR(20)    DEFAULT ''                    NOT NULL,      -- コンテンツID
    ic_language_id       VARCHAR(2)     DEFAULT ''                    NOT NULL,      -- 言語ID
    ic_history_index     INT            DEFAULT 0                     NOT NULL,      -- 履歴管理用インデックスNo(0～)
    ic_name              VARCHAR(40)    DEFAULT ''                    NOT NULL,      -- コンテンツ名
    ic_description       VARCHAR(100)   DEFAULT ''                    NOT NULL,      -- 説明
    ic_html              TEXT                                         NOT NULL,      -- コンテンツHTML
    
    ic_check_out_user_id INT            DEFAULT 0                     NOT NULL,      -- チェックアウトユーザID(0のときはチェックイン状態)
    ic_check_out_dt      TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- チェックアウト日時
    ic_create_user_id    INT            DEFAULT 0                     NOT NULL,      -- レコード作成者
    ic_create_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- レコード作成日時
    ic_update_user_id    INT            DEFAULT 0                     NOT NULL,      -- レコード更新者
    ic_update_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- レコード更新日時
    ic_locked            BOOLEAN        DEFAULT false                 NOT NULL,      -- レコードロック状態
    ic_deleted           BOOLEAN        DEFAULT false                 NOT NULL,      -- レコード削除状態
    PRIMARY KEY          (ic_serial),
    UNIQUE               (ic_widget_id,         ic_id,                ic_language_id,               ic_history_index)
) TYPE=innodb;


-- ブログエントリー(記事)マスター
DROP TABLE IF EXISTS blog2_entry;
CREATE TABLE blog2_entry (
    be_serial            INT            AUTO_INCREMENT,                              -- レコードシリアル番号
    be_group_id          INT            DEFAULT 0                     NOT NULL,      -- ブロググループID
    be_id                INT            DEFAULT 0                     NOT NULL,      -- エントリーID
    be_history_index     INT            DEFAULT 0                     NOT NULL,      -- 履歴管理用インデックスNo(0～)
    
    be_name              VARCHAR(40)    DEFAULT ''                    NOT NULL,      -- エントリータイトル
    be_html              TEXT                                         NOT NULL,      -- エントリー本文HTML
    be_html_ext          TEXT                                         NOT NULL,      -- エントリー本文HTML(続き)
    be_description       VARCHAR(100)   DEFAULT ''                    NOT NULL,      -- 概要
    be_status            SMALLINT       DEFAULT 0                     NOT NULL,      -- エントリー状態(0=未設定、1=編集中、2=公開、3=非公開)
    be_search_tag        VARCHAR(100)   DEFAULT ''                    NOT NULL,      -- 検索用タグ(「,」区切り)
    be_regist_user_id    INT            DEFAULT 0                     NOT NULL,      -- エントリー作者
    be_regist_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- 投稿日時
    be_active_start_dt   TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- 公開期間(開始)
    be_active_end_dt     TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- 公開期間(終了)

    be_check_out_user_id INT            DEFAULT 0                     NOT NULL,      -- チェックアウトユーザID(0のときはチェックイン状態)
    be_check_out_dt      TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- チェックアウト日時
    be_create_user_id    INT            DEFAULT 0                     NOT NULL,      -- レコード作成者
    be_create_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- レコード作成日時
    be_update_user_id    INT            DEFAULT 0                     NOT NULL,      -- レコード更新者
    be_update_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- レコード更新日時
    be_deleted           BOOLEAN        DEFAULT false                 NOT NULL,      -- レコード削除状態
    PRIMARY KEY          (be_serial),
    UNIQUE               (be_group_id,  be_id,  be_history_index)
) TYPE=innodb;


-- BBS_TITLE=掲示板
-- BBS_TITLE_PICTURE=../php.gif
-- BBS_TITLE_COLOR=#000000
-- BBS_TITLE_LINK=../../
-- BBS_BG_COLOR=#EFEFEF
-- BBS_BG_PICTURE=../ba.gif
-- BBS_NONAME_NAME=名無しさん＠お腹いっぱい。
-- BBS_MAKETHREAD_COLOR=#CCFFCC
-- BBS_MENU_COLOR=#CCFFCC
-- BBS_THREAD_COLOR=#EFEFEF
-- BBS_TEXT_COLOR=#000000
-- BBS_NAME_COLOR=green
-- BBS_LINK_COLOR=#0000FF
-- BBS_ALINK_COLOR=#FF0000
-- BBS_VLINK_COLOR=#660099
-- BBS_THREAD_NUMBER=10
-- BBS_CONTENTS_NUMBER=10
-- BBS_LINE_NUMBER=15
-- BBS_MAX_MENU_THREAD=40
-- BBS_SUBJECT_COLOR=#FF0000
-- BBS_UNICODE=pass
-- BBS_DELETE_NAME=あぼーん
-- BBS_NAMECOOKIE_CHECK=checked
-- BBS_MAILCOOKIE_CHECK=checked
-- BBS_SUBJECT_COUNT=48
-- BBS_NAME_COUNT=64
-- BBS_MAIL_COUNT=64
-- BBS_MESSAGE_COUNT=2048
-- BBS_THREAD_TATESUGI=
-- NANASHI_CHECK=
-- timecount=
-- timeclose=
-- BBS_PROXY_CHECK=
-- BBS_OVERSEA_THREAD=
-- BBS_OVERSEA_PROXY=
-- BBS_DISP_IP=
-- BBS_FORCE_ID=
-- BBS_NO_ID=

-- ------ VIP機能 -----
-- # ログファイル保持数（システム設定）define('KEEPLOGCOUNT', $_POST[KEEPLOGCOUNT]);
-- # 1スレッドに投稿できるレス数の上限define('THREAD_RES', $_POST[THREAD_RES]);
-- # レスオーバー時のメッセージdefine('THREAD_MAX_MSG', '$_POST[THREAD_MAX_MSG]');
-- # 1スレッドの上限（バイト）define('THREAD_BYTES', $_POST[THREAD_BYTES]);
-- # ファイルアップ許可define('UPLOAD', $_POST[UPLOAD]);
-- # アップロード上限（バイト）define('MAX_BYTES', $_POST[MAX_BYTES]);
-- # サムネイル画像の幅define('MAX_W', $_POST[MAX_W]);
-- # サムネイル画像の高さdefine('MAX_H', $_POST[MAX_H]);
-- # おみくじ機能define('OMIKUJI', $_POST[OMIKUJI]);
-- # 野球機能define('BASEBALL', $_POST[BASEBALL]);
-- # どこ誰何機能define('WHO_WHERE', $_POST[WHO_WHERE]);
-- # 壷機能（未実装）define('TUBO', $_POST[TUBO]);
-- # 等幅フォント機能define('TELETYPE', $_POST[TELETYPE]);
-- # スレッド内名無し名変更機能define('NAME_774', $_POST[NAME_774]);
-- # 名無しへ強制変更機能define('FORCE_774', $_POST[FORCE_774]);
-- # IDなし機能define('FORCE_NO_ID', $_POST[FORCE_NO_ID]);
-- # sage強制機能define('FORCE_SAGE', $_POST[FORCE_SAGE]);
-- # レス要キャップ機能define('FORCE_STARS', $_POST[FORCE_STARS]);
-- # スレッド内VIP機能解除define('FORCE_NORMAL', $_POST[FORCE_NORMAL]);
-- # 名前入力強制機能define('FORCE_NAME', $_POST[FORCE_NAME]);
-- # 0thelo機能define('ZEROTHELO', $_POST[ZEROTHELO]);
-- # アップロード機能define('FORCE_UP', $_POST[FORCE_UP]);

--
-- # gzip圧縮をする（TRUE=する、FALSE=しない）広告が自動で挿入されるサーバでは使えませんdefine('GZ_FLAG', FALSE);
-- # 時間規制する（TRUE=する、FALSE=しない）define('JIKAN_KISEI', FALSE);
-- # 規制開始時間（0-23）define('JIKAN_START', 22);
-- # 規制終了時間（0-23）define('JIKAN_END', 2);

-- BBS(2ch)アクセス制御マスター
DROP TABLE IF EXISTS bbs_2ch_access;
CREATE TABLE bbs_2ch_access (
    ta_board_id          VARCHAR(30)    DEFAULT ''                    NOT NULL,      -- 掲示板ID(空文字列=デフォルト)
    ta_host_ip           VARCHAR(100)   DEFAULT ''                    NOT NULL,      -- アクセス元ホスト名またはIP
    ta_type              INT            DEFAULT 0                     NOT NULL,      -- アクセス制御(0=アクセス許可、1=アクセス拒否)
    PRIMARY KEY          (ta_board_id,  ta_host_ip)
) TYPE=innodb;

-- BBS(2ch)アクセスログトラン
DROP TABLE IF EXISTS bbs_2ch_access_log;
CREATE TABLE bbs_2ch_access_log (
    tl_serial            INT            AUTO_INCREMENT,                              -- レコードシリアル番号
    tl_board_id          VARCHAR(30)    DEFAULT ''                    NOT NULL,      -- 掲示板ID(空文字列=デフォルト)
    tl_host              VARCHAR(100)   DEFAULT ''                    NOT NULL,      -- アクセス元ホスト名
    tl_ip                VARCHAR(40)    DEFAULT ''                    NOT NULL,      -- アクセス元IP(IPv6対応)
    tl_term_id           VARCHAR(40)    DEFAULT ''                    NOT NULL,      -- 端末ID(PCの場合はクッキー値、携帯の場合は端末ID)
    tl_access_log        INT            DEFAULT 0                     NOT NULL,      -- アクセスログシリアル番号
    tl_dt                TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- 記録日時
    PRIMARY KEY          (tl_serial)
) TYPE=innodb;

-- ユーザコンテンツ参照トラン
/*DROP TABLE IF EXISTS user_content_view_count;
CREATE TABLE user_content_view_count (
    uv_serial            INT            AUTO_INCREMENT,                              -- レコードシリアル番号
    uv_id                VARCHAR(20)    DEFAULT ''                    NOT NULL,      -- ルームID
    uv_tab_id            VARCHAR(20)    DEFAULT ''                    NOT NULL,      -- タブID(空文字列=ルーム全体)
    uv_date              DATE           DEFAULT '0000-00-00'          NOT NULL,      -- 日付
    uv_hour              SMALLINT       DEFAULT 0                     NOT NULL,      -- 時間
    uv_count             INT            DEFAULT 0                     NOT NULL,      -- 参照数
    PRIMARY KEY          (uv_serial),
    UNIQUE               (uv_id,        uv_tab_id,     uv_date,       uv_hour)
) TYPE=innodb;*/


/*
('menu_color',            '#CCFFCC',               ''),
('thread_color',          '#EFEFEF',               ''),


('makethread_color',      '#CCFFCC',                    ''),

('title',                 '掲示板',                     '掲示板タイトル'),
('top_image',             'tubo.gif',                   'トップ表示画像'),
('title_color',           '#000000',                    'タイトル背景色'),
('top_link',              '',                           'トップ画像のリンク先'),
('noname_name',           '名無しさん＠お腹いっぱい。', '名前未設定時の表示名'),
('thread_count',         '10',                         'トップ画面に表示するスレッド最大数'),
('menu_thread_count',       '40',                         'メニューに表示するスレッド最大数'),
('res_count',             '10',                         'トップ画面に表示するレス最大数'),
('link_number',           '15',                         ''),

*/
