/*
 * graph2D
 * Copyright (c) 2009 Shun Moriya <shun126@users.sourceforge.jp>
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 *
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 *
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

#include "common.h"
#include "abort.h"
#include <stdio.h>
#include <string.h>

#if defined(TARGET_WINDOWS)
 #if !defined(_DEBUG)
  #define _CRT_SECURE_NO_WARNINGS
 #endif
 #include <windows.h>
 #include "platform/windows/abort_impl.h"
 #define MESSAGE		const wchar_t*
#elif defined(TARGET_IPHONE)
 #include "platform/iOS/abort_impl.h"
 #define MESSAGE		const char*
#endif

namespace Graph2D
{
	static MESSAGE* errorMessageArray[ERROR_CODE_SIZE] = {
		&errorMessages[0],
		&errorMessages[1],
		&errorMessages[1],
		&errorMessages[1],
		&errorMessages[2],
		&errorMessages[3],
		&errorMessages[3],
		&errorMessages[3],
		&errorMessages[3],
	};

	void abort(const ERROR_CODE errorCode, const char* hint)
	{
#if defined(TARGET_WINDOWS)
		static MESSAGE errorTitle = L"ERROR";
		wchar_t message[512];
		::swprintf_s(message, sizeof(message), L"%s (%d)", errorMessageArray[errorCode], errorCode);
		if(hint)
		{
			size_t size = strlen(hint) + 1;
			size_t result = 0;
			wchar_t w_hint[512];
			mbstowcs_s(&result, w_hint, size, hint, _TRUNCATE);
			wcscat_s(message, sizeof(message), L" ... ");
			wcscat_s(message, sizeof(message), w_hint);
		}
		Windows::abort_impl(message);

#elif defined(TARGET_IPHONE)
		char message[512];
		::sprintf(message, "%s (%d)", *errorMessageArray[errorCode], errorCode);
		if(hint)
		{
			strcat(message, " ... ");
			strcat(message, hint);
		}
		Implementation::abort_impl(message);
#endif
	}
}
