/*
 * graph2D
 * Copyright (c) 2011 Shun Moriya <shun126@users.sourceforge.jp>
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 *
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 *
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

#if !defined(___GRAPH2D_ALLOCATOR_H___)
#define ___GRAPH2D_ALLOCATOR_H___

#if !defined(NDEBUG)
// gp
// allocator->malloc(a _GRAPH2D_ALLOCATOR_COMMENT_)
#define __GRAPH2D_ALLOCATOR_MACRO_STR(x)	#x
#define __GRAPH2D_ALLOCATOR_MACRO_XSTR(x)	"("__GRAPH2D_ALLOCATOR_MACRO_STR(x)")"
#define _GRAPH2D_ALLOCATOR_COMMENT_			,__FILE__ __GRAPH2D_ALLOCATOR_MACRO_XSTR(__LINE__)
#else
#define _GRAPH2D_ALLOCATOR_COMMENT_
#endif

namespace Graph2D
{
	//! AP[^[NX
	class Allocator
	{
		static const int MEMORY_ALIGN_SIZE = 16;	//!< WACg

		//! ǗubN
		typedef struct MemoryBlock
		{
			unsigned short identification;		//!< j[Nhc
			unsigned char reffrenceCount;		//!< QƃJE^
			unsigned char flag;					//!< tO
/*
 *  tagMemoryBlock :: flag
 *
 *  |  7 |  6 |  5 |  4 |  3 |  2 |  1 |  0 |
 *  |    |    |    |    |    |    |    |
 *  |    |    |    |    |    |    |    +------ MEMORY_BLOCK_FLAG_CACHE
 *  |    |    |    |    |    |    +----------- MEMORY_BLOCK_FLAG_LOCK_CACHE
 *  |    |    |    |    |    +---------------- MEMORY_BLOCK_FLAG_INITIALIZED
 *  |    |    |    |    +---------------------
 *  |    |    |    +--------------------------
 *  |    |    +-------------------------------
 *  |    +------------------------------------
 *  +----------------------------------------- MEMORY_BLOCK_FLAG_MARKER_UNUSE
 */

			struct MemoryBlock* previous;		//!< ÕubNւ̃|C^
			struct MemoryBlock* next;			//!< ̃ubNւ̃|C^
			struct MemoryBlock* previousFree;	//!< Ő󂫃ubNւ̃|C^
			struct MemoryBlock* nextFree;		//!< ̋󂫃ubNւ̃|C^
			struct MemoryBlock*	previousCache;	//!< ÕLbVւ̃|C^
			struct MemoryBlock*	nextCache;		//!< ̃LbVւ̃|C^
			int size;							//!< TCY(Ȃ΋󂫁BȂgp)
#if !defined(NDEBUG)
			const char* comment;				//!< Rgւ̃|C^
#endif
			// method
			void mergePreviousFreeList();
			void removeFreeList();
			void removeCacheList();
			void insertPreviousUseList(MemoryBlock* block);
			void insertNextUseList(MemoryBlock* block);
			void removeUseList();
		}MemoryBlock;
	
		MemoryBlock block_expansion;		//!< g
		MemoryBlock* block_head_address;	//!< ubN擪|C^
#if !defined(NDEBUG)
		MemoryBlock* block_tail_address;	//!< ubNŏI|C^
#endif
		unsigned int size;					//!< TCY
		unsigned int number_of_blocks;		//!< ubN
		//sem_t semaphore;					//!< NeBJZNVIuWFNg

		void insertFreeList(MemoryBlock* block);
		void insertCacheList(MemoryBlock* block);

		int getAlignedSize(int size);
		int getHeaderSize();

		MemoryBlock* toHeader(void* block);
		void* toData(MemoryBlock* block);

		void lock();
		void unlock();

		MemoryBlock* _merge(MemoryBlock* block);
		MemoryBlock* _free(void* pointer);
		void* _malloc_low(int size);
		void* _malloc_high(int size);
		void* _malloc(int size);
		void* _memalign(int alignment, int size);
		void _reduce(MemoryBlock* block, int size);
		void* _expand(MemoryBlock* block, int size, int difference);
		void* _realloc(void* pointer, int size);
		void _compact_move_cache_block(MemoryBlock* block);
		bool _compact(int size);
		int _compact_easy(int blocks);
		bool _cache_sweep(int size);
		int _cache_sweep_all();
		void* _cache_assign(unsigned short identification);
		void* _memalign_low(int alignment, int size);
		int _get_available_size();
		int _get_free_size();
		int _get_used_size();

	public:
		Allocator();
		~Allocator();

		void initialize(void* buffer, int size);
		void finalize();

#if !defined(NDEBUG)
		void* malloc(int size, const char* comment);
		void* calloc(int count, int size, const char* comment);
		void* realloc(void* pointer, int size, const char* comment);
		void* memalign(int alignment, int size, const char* comment);
#else
		void* malloc(int);
		void* calloc(int, int);
		void* realloc(void*, int);
		void* memalign(int, int);
#endif

		bool compact(int size);
		void compact_easy(int blocks);
		bool cache_sweep(int size);
		void cache_sweep_all();
		void* cache_assign(unsigned short identification);
		void* cache_malloc(unsigned short identification, int size);
		void* cache_memalign(unsigned short identification, int alignment, int size);
		int cache_is_initialized(void* pointer);
		void cache_lock(void* pointer);
		void cache_unlock(void* pointer);
		unsigned int cache_get_infomation(unsigned int& total_size, unsigned int& use_size, unsigned int& free_size);

		void free(void* pointer);

		unsigned int get_size(void* pointer);
		unsigned int get_block_count();
		unsigned int get_total_size();
		unsigned int get_available_size();
		unsigned int get_free_size();
		unsigned int get_used_size();
		unsigned char get_reffrence_count(void* pointer);

#if !defined(NDEBUG)
		void check();
		void set_message(void* pointer, const char* comment);
#endif
	};
}

#endif
