/*
 * graph2D
 * Copyright (c) 2009 Shun Moriya <shun126@users.sourceforge.jp>
 * 
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 * 
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 * 
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 * 
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 * 
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

/*!
 * @file
 * @brief	ϒzev[g
 *
 * ̃t@C͉ϒzev[gNX֌Wwb_[t@CłB
 *
 * @author	Shun Moriya <shun126@users.sourceforge.jp>
 */

#if !defined(___GRAPH2D_ARRAY_H___)
#define ___GRAPH2D_ARRAY_H___

#include <stdlib.h>

namespace Graph2D
{
	/*!
	 * @class
	 * @brief	ArrayNX
	 */
	template <class T> class Array
	{
		int pageSize;					//!< zmۂ鎞̃y[WTCY
		int allocatedSize;				//!< mۍς݃TCY
		int usedSize;					//!< gpς݃TCY
		T* datas;						//!< f[^|C^

	public:
		/*!
		 * @brief		RXgN^
		 * @param[in]	allocateSize	mۂTCY
		 * @param[in]	pageSize		y[WTCY
		 */
		Array(const int allocateSize = 0, const int pageSize = 10)
		{
			this->datas = NULL;
			this->allocatedSize = 0;
			this->usedSize = 0;
			setPageSize(pageSize);
			if(allocateSize > 0)
				resize(allocateSize);
		}

		/*!
		 * @brief	fXgN^
		 */
		virtual ~Array()
		{
			release();
		}

	public:
		/*!
		 * @brief	z
		 */
		void release()
		{
			g2d_free(datas);
			datas = NULL;

			allocatedSize = usedSize = 0;
		}

		/*!
		 * @brief	z̃TCYgp̃TCYƈv܂
		 * @retval	true	쐬
		 * @retval	false	쎸s
		 */
		bool compact()
		{
			return resize(usedSize);
		}

		/*!
		 * @brief	gpTCY擾
		 * @return	gpTCY
		 */
		int size() const
		{
			return usedSize;
		}

		/*!
		 * @brief		y[WTCYݒ
		 * @param[in]	pageSize	y[WTCY
		 */
		void setPageSize(const int pageSize)
		{
			this->pageSize = pageSize;
			if(this->pageSize <= 0)
				this->pageSize = 10;
		}

		/*!
		 * @brief		z񂩂NX̎QƂ擾܂
		 * @param[in]	index	zԍ
		 * @return		NX
		 */
		T get(const int index)
		{
			return datas[index];
		}

		/*!
		 * @brief		z񂩂NX̎QƂ擾܂ (const)
		 * @param[in]	index	zԍ
		 * @return		NX
		 */
		const T get(const int index) const
		{
			return datas[index];
		}

		/*!
		 * @brief		NXݒ肵܂
		 * @param[in]	index	zԍ
		 * @param[in]	data	NX
		 * @retval		true	쐬
		 * @retval		false	쎸s
		 */
		bool set(const int index, const T data)
		{
			if(index >= usedSize)
				usedSize = index + 1;

			if(index >= allocatedSize)
			{
				if(!resize((usedSize + (pageSize - 1)) / pageSize * pageSize))
					return false;
			}

			datas[index] = data;
			
			return true;
		}

		/*!
		 * @brief		NXzɒǉ܂
		 * @param[in]	data	NX
		 * @retval		>= 0	ǉꂽzԍ
		 */
		int push(const T data)
		{
			const int index = usedSize;

			if(index + 1 >= allocatedSize)
			{
				if(!resize((usedSize + pageSize) / pageSize * pageSize))
					return -1;
			}

			usedSize++;

			datas[index] = data;

			return index;
		}

		/*!
		 * @brief		z񂩂NX̎QƂ擾܂
		 * @param[in]	index	zԍ
		 * @return		NX
		 */
		T operator[](const int index)
		{
			return get(index);
		}

		/*!
		 * @brief		z񂩂NX̎QƂ擾܂ (const)
		 * @param[in]	index	zԍ
		 * @return		NX
		 */
		const T operator[](int index) const
		{
			return get(index);
		}

		/*!
		 * @brief	AhX擾܂
		 * @return	AhX
		 */
		operator T()
		{
			return static_cast<T>(datas);
		}
		
		/*!
		 * @brief	AhX擾܂ (const)
		 * @return	AhX
		 */
		operator const T() const
		{
			return static_cast<const T>(datas);
		}

	private:
		/*!
		 * @brief		mۂ܂
		 * @param[in]	allocateSize	mۂTCY
		 * @retval		true	mې
		 * @retval		false	mێs
		 */
		bool resize(const int allocateSize)
		{
			datas = (T*)g2d_realloc(datas, allocateSize * sizeof(T));
			if(datas)
			{
				allocatedSize = allocateSize;
				return true;
			}
			else
			{
				release();
				return false;
			}
		}
	};
}

#endif
