/*
 * graph2D
 * Copyright (c) 2009 Shun Moriya <shun126@users.sourceforge.jp>
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 *
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 *
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

#if !defined(___GRAPH2D_BASE_H___)
#define ___GRAPH2D_BASE_H___

#include "common.h"
#if !defined(TARGET_WINDOWS)
#include <new>
#endif

namespace Graph2D
{
	/*template<typename T> */class Base
	{
		DISALLOW_COPY_AND_ASSIGN(Base);

		unsigned short count;

	protected:
		virtual ~Base()
		{
			assert(count == 0);
		}

	public:
		Base() : count(1)
		{
		}

		Base* retain()
		{
			++count;
			return this;
		}

		virtual void release()
		{
			if(--count <= 0)
			{
				delete this;
			}
		}

		unsigned short retainCount() const
		{
			return count;
		}

#if !defined(TARGET_WINDOWS)
#if defined(NDEBUG)
		static void* operator new(size_t size) throw();
		static void* operator new[](size_t size) throw();
#else
		static void* operator new(size_t size, const char* comment = __FILE__ __GRAPH2D_ALLOCATOR_MACRO_XSTR(__LINE__)) throw();
		static void* operator new[](size_t size, const char* comment = __FILE__ __GRAPH2D_ALLOCATOR_MACRO_XSTR(__LINE__)) throw();
#endif
		static void operator delete(void* buffer) throw();
		static void operator delete[](void* buffer) throw();
#endif
	};

	class AutoRelease
	{
		Base* base;

	public:
		AutoRelease()
		{
			base = 0;
		}

		explicit AutoRelease(Base* base)
		{
			this->base = base;
		}

		~AutoRelease()
		{
			if(base)
				base->release();
		}
	};
#define ___AUTO_RELEASE_NAME_MACRO(HEAD, BASE, LINE, TAIL) HEAD##BASE##LINE##TAIL
#define ___AUTO_RELEASE_LINE_MACRO(LINE, BASE) ___AUTO_RELEASE_NAME_MACRO(Graph2D::AutoRelease _____GRAPH2D_, BASE, LINE, _AUTO_RELEASE_____)(BASE)
#define AUTO_RELEASE(BASE) ___AUTO_RELEASE_LINE_MACRO(__LINE__, BASE)
#define SAFE_ASSIGN(destination, source){\
	if(destination)\
		destination->release();\
	destination = source;\
	if(destination)\
		destination->retain();\
}

}

#endif
