/*
 * graph2D
 * Copyright (c) 2009 Shun Moriya <shun126@users.sourceforge.jp>
 * 
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 * 
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 * 
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 * 
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 * 
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

#include "borderLayout.h"
#include "container.h"

namespace Graph2D
{
	BorderLayout::BorderLayout()
	{
	}

	BorderLayout::~BorderLayout()
	{
	}

	void BorderLayout::apply(Container* container)
	{
		Component* component;

		if(container == NULL)
			return;

		const Vector2& frameSize = container->getSize();
		float left = 0;
		float top = 0;
		float right = frameSize.x;
		float bottom = frameSize.y;

		component = container->get(NORTH);
		if(component)
		{
			top = component->getSize().y;
			component->setPosition(0, 0);
			component->setSize(frameSize.x, top);
		}

		component = container->get(SOUTH);
		if(component)
		{
			const float height = component->getSize().y;
			bottom = frameSize.y - height;
			component->setPosition(0.0f, bottom);
			component->setSize(frameSize.x, height);
			
		}

		component = container->get(EAST);
		if(component)
		{
			left = component->getSize().x;
			component->setPosition(0.0f, top);
			component->setSize(left, bottom - top);
		}

		component = container->get(WEST);
		if(component)
		{
			const float width = component->getSize().x;
			right = frameSize.x - width;
			component->setPosition(right, top);
			component->setSize(width, bottom - top);
			
		}

		component = container->get(CENTER);
		if(component)
		{
			component->setPosition(left, top);
			component->setSize(right - left, bottom - top);
		}
	}
}
