/*
 * graph2D
 * Copyright (c) 2009 Shun Moriya <shun126@users.sourceforge.jp>
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 *
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 *
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

#if !defined(___GRAPH2D_COMMON_H___)
#define ___GRAPH2D_COMMON_H___

#include <cassert>
#include "heap.h"

#if !defined(DISALLOW_COPY_AND_ASSIGN)
#define DISALLOW_COPY_AND_ASSIGN(TypeName)	\
TypeName(const TypeName&);					\
void operator=(const TypeName&)
#endif

#if !defined(TARGET_DETECTED)
 #define TARGET_DETECTED
 #if defined(_WIN32) || defined(_WIN64)
  #define TARGET_WINDOWS
 #elif defined(__APPLE__)
  #define TARGET_APPLE
  #if defined(__IPHONE_OS_VERSION_MIN_REQUIRED)
   #define TARGET_IPHONE
  #elif defined(__MAC_OS_X_VERSION_MIN_REQUIRED)
   #define TARGET_MAC_OSX
  #else
   #error Unknown platform.
  #endif
 #else
  #error Platform Not Supported.
 #endif
#endif

#if (defined(DEBUG) || defined(_DEBUG) || defined(_DEBUG_)) || !defined(NDEBUG)
/*
 * 0 ... no log
 * 1 ... trigger on event
 * 2 ... update on event
 * 3 ... every update (debug for critical bugs)
 */
#define GRAPH2D_LOG_DETAIL_LEVEL	1
#else
#define GRAPH2D_LOG_DETAIL_LEVEL	0
#endif


#endif
