/*
 * graph2D
 * Copyright (c) 2009 Shun Moriya <shun126@users.sourceforge.jp>
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 *
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 *
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

#if !defined(___GRAPH2D_COMPONENT_H___)
#define ___GRAPH2D_COMPONENT_H___

#include "base.h"
#include "cellAnimation.h"
#include "color.h"
#include "data.h"
#include "graphicDevice.h"
#include "texture.h"
#include "vector2.h"

#include <cstddef>
#include <map>
#include <stack>
#include <string>

namespace Graph2D
{
	class Component;
	class Container;
	class Scene;

	////////////////////////////////////////////////////////////////////////////////
	static const int TYPE_COMPONENT		= (0x00000001);						//!< Component
	static const int TYPE_SCROLL_BAR	= (0x00000002|TYPE_COMPONENT);		//!< ScrollBar
	static const int TYPE_TEXT			= (0x00000004|TYPE_COMPONENT);		//!< Text
	static const int TYPE_CONTAINER		= (0x00000008|TYPE_COMPONENT);		//!< Container
	static const int TYPE_IMAGE_BUTTON	= (0x00000010|TYPE_CONTAINER);		//!< ImageButton
	static const int TYPE_BUTTON		= (0x00000020|TYPE_IMAGE_BUTTON);	//!< Button
	static const int TYPE_MESSAGE		= (0x00000040|TYPE_CONTAINER);		//!< Message
	static const int TYPE_SCENE			= (0x00000080|TYPE_CONTAINER);		//!< Scene
	static const int TYPE_WINDOW		= (0x00000100|TYPE_CONTAINER);		//!< Window
	static const int TYPE_MENU			= (0x00000200|TYPE_WINDOW);			//!< Menu
	static const int TYPE_DIALOG		= (0x00000400|TYPE_MENU);			//!< Dialog
	static const int TYPE_MESSAGE_WINDOW= (0x00000800|TYPE_WINDOW);			//!< MessageWindow
	static const int TYPE_TEXT_WINDOW	= (0x00001000|TYPE_WINDOW);			//!< MessageWindow
	static const int TYPE_CUSTOM		= (0x00002000);						//!< [U[`

	////////////////////////////////////////////////////////////////////////////////
	//! t[̃X^C
	typedef enum FrameStyle
	{
		FRAME_STYLE_NORMAL = 0x00,			//!< ʏX^C
		FRAME_STYLE_PUSHED = 0x01,			//!< {^ꂽX^C
		FRAME_STYLE_NOLINE = 0x02,			//!< gȂ
		FRAME_STYLE_FLAT   = 0x04,			//!< tbgVF[h
		FRAME_STYLE_CUSTOM = 0x10,			//!< X^CiȂj
	}FrameStyle;

	////////////////////////////////////////////////////////////////////////////////
	//! eLXgACg 
	typedef enum TextAlignmentH
	{
		TEXT_ALIGNMENT_LEFT,				//!< Â
		TEXT_ALIGNMENT_CENTER,				//!< 
		TEXT_ALIGNMENT_RIGHT,				//!< EÂ
	}TextAlignmentH;

	//! eLXgACg 
	typedef enum TextAlignmentV
	{
		TEXT_ALIGNMENT_TOP,					//!< Â
		TEXT_ALIGNMENT_MIDDLE,				//!< 
		TEXT_ALIGNMENT_BOTTOM,				//!< Â
	}TextAlignmentV;

	////////////////////////////////////////////////////////////////////////////////
	typedef struct UpdateInfomation
	{
		/*!
		 * i񂾃Jg
		 */
		float deltaTime;

		/*!
		 * x[XƂȂFPSŊlBȂ1.0B
		 *  =1.0f, { = 0.5f, x[X60fps30fpsɗ(2.0)ɂȂ
		 */
		float stepCount;
	}UpdateInfomation;

	////////////////////////////////////////////////////////////////////////////////
	class ActionEvent
	{
	public:
		virtual void onAction(Component* component, const unsigned int identification) = 0;
	};

	////////////////////////////////////////////////////////////////////////////////
	class ClickEvent
	{
	public:
		virtual void onClick(Component* component) = 0;
	};

	////////////////////////////////////////////////////////////////////////////////
	class MouseEvent
	{
		virtual bool onTouchesBegan(const Vector2& localPosition) = 0;
		virtual bool onTouchesEnded(const Vector2& localPosition) = 0;
		virtual bool onTouchesMoved(const Vector2& localPosition) = 0;
		virtual bool onTouchesCancelled(const Vector2& localPosition) = 0;
	};

	////////////////////////////////////////////////////////////////////////////////
	class Component : public Base, public MouseEvent
	{
		DISALLOW_COPY_AND_ASSIGN(Component);

		typedef Base super;

		friend class Container;

	protected:
		unsigned int type;						//!< R|[lg^Cv
		unsigned int identification;			//!< j[Nԍ

		Container* parent;						//!< eR|[lg

		Vector2 position;						//!< ʒu
		Vector2 size;							//!< TCY
		Vector2 toucheBeganPosition;			//!< ^b`JnW
		Vector2 offset;							//!< jump/shakepoffset position

		Vector2 scale;							//!< XP[
		Vector2 animationDeltaScale;			//!< XP[ύX
		Vector2 animationTargetScale;			//!< XP[ύXړIXP[
		float scaleTime;						//!< XP[ύX
		bool scaleEnable:8;						//!< XP[ύXtO

		Color color;							//!< F

		Texture* texture;						//!< eNX`
		Vector2 textureScrollOffset;
		Vector2 textureScrollSpeed;

		Vector2 animationCellStartPosition;		//!< ZAj[VJnʒu
		Vector2 animationCellSize;				//!< ZAj[VTCY
		float animationCellTime;				//!< ZAj[V
		float animationCellWait;				//!< ZAj[VEFCg
		unsigned short animationCellCount;		//!< ZAj[V
		unsigned short animationCellMaxCount;	//!< ZAj[V
		short animationCellLoopCountOrigin;
		short animationCellLoopCount;			//!< ZAj[VĐ񐔁iȂ疳j
		bool animationCellEnable:8;				//!< ZAj[VtO
		bool animationCellRunning:8;			//!< ZAj[VstO

		std::map<std::string, CellAnimation*> animations;	//!< ZAj[V

		Color fadeDeltaColor;					//!< FtF[h
		Color fadeTargetColor;					//!< FtF[hړIF
		float fadeColorTime;					//!< FtF[h
		bool fadeColorEnable:8;					//!< FtF[htO

		Vector2 animationDeltaPosition;			//!< ʒuAj[V
		Vector2 animationTargetPosition;		//!< ʒuAj[VړIF
		float animationPositionTime;			//!< ʒuAj[V
		unsigned char animationPositionEnable;	//!< ʒuAj[VtO

		float jumpTime;							//!< Wv
		float jumpAngle;						//!< Wvpx
		float jumpHeight;						//!< Wv

		float shakeTime;						//!< U
		float shakeLength;						//!< U
		float shakeAmplitude;					//!< U

		ActionEvent* actionEvent;
		int data;								//!< ֘Atf[^

		float enableColor;						//!< LEύX̋Pxl

		unsigned char frameStyle;				//!< t[̃X^C
		unsigned char flags;					//!< ԃtO
		unsigned char blendMode;				//!< uh[h

		//TODO:ǂȋ@\F]Aj[ViVUOǂHj
		//TODO:ǂȋ@\FXP[Aj[V
		//TODO:ǂȋ@\FtB^[nGtFNg
		//TODO:{NX傫Ȃ肷Ă̂ŕ܂傤

	private:
		static std::map<unsigned int, Component*> components;
		static std::map<std::string, Texture*> textures;
		static std::stack<Component*> mouseCaptureComponent;
		static Component* lastFoundComponent;
		static unsigned int componentCounter;
		static unsigned int lastTouchedComponentID;
		static bool drawDebugInfomation;
		static bool dragging;

	protected:
		virtual ~Component();							//!< fXgN^

	public:
		Component();									//!< RXgN^

		virtual void release();							//!< J

		void removeFromParent();						//!< eJ܂

		unsigned int getType() const					//!< ^CvID擾܂
		{
			return type;
		}

		bool isA(const unsigned int type) const
		{
			return this->type == type;
		}

		bool isKindOfA(const unsigned int type) const
		{
			const unsigned int mask = this->type & type;
			return mask == type;
		}

		unsigned int getID() const						//!< R|[lgID擾܂
		{
			return identification;
		}

		static unsigned int getLastTouchedID()			//!< ŌɃ^b`ꂽR|[lgID擾܂
		{
			return lastTouchedComponentID;
		}

		virtual const char* getTypeName() const			//!< ^Cv擾܂
		{
			return "Component";
		}

		Container* getParent() const					//!< eR|[lg擾܂
		{
			return parent;
		}

		Scene* getParentScene() const;

		Container* forcusScrollableContainer(const Vector2& localPosition);

		Container* getScrollableContainer();
		const Container* getScrollableContainer() const
		{
			return getScrollableContainer();
		}

		unsigned int getFrameStyle() const				//!< t[X^C擾܂
		{
			return frameStyle;
		}

		void setFrameStyle(const unsigned int style)	//!< t[X^Cݒ肵܂
		{
			this->frameStyle = style;
		}

		Vector2 getScreenPosition() const;				//!< XN[W擾܂
		Vector2 translatePosition(const Vector2& screenPosition) const;	//!< XN[W[JWɕϊ܂

		Vector2 getPosition() const						//!< [JW擾܂
		{
			return position + offset;
		}

		virtual void setPosition(const Vector2& position)		//!< [JWݒ肵܂
		{
			this->position = position;
		}

		virtual void setPosition(const float x, const float y)	//!< [JWݒ肵܂
		{
			position = Vector2(x, y);
		}

		Vector2 getCenterPosition() const				//!< [JSW擾܂
		{
			return getPosition() + getSize() * 0.5f;
		}

		Vector2 getLeftTopPosition() const				//!< XP[W擾܂
		{
			return getCenterPosition() - getSize() * 0.5f * getScale();
		}

		Vector2 getRightBottom() const					//!< XP[EW擾܂
		{
			return getCenterPosition() + getSize() * 0.5f * getScale();
		}

		Vector2 getBottomPosition() const				//!< [JW擾܂
		{
			return position + getSize() * Vector2(0.5f, 1.0f);
		}

		void setBottomPosition(const Vector2& position);//!< [JWݒ肵܂

		const Vector2& getSize() const					//!< TCY擾܂
		{
			return animationCellEnable ? animationCellSize : size;
		}

		void setSize(const Vector2& size);
		void setSize(const float w, const float h)		//!< TCYݒ肵܂
		{
			setSize(Vector2(w, h));
		}

		float getWidth() const;
		void setWidth(const float w);

		float getHeight() const;
		void setHeight(const float h);

		const Vector2& getScale() const					//!< XP[擾܂
		{
			return scale;
		}

		void setScale(const Vector2& scale, const float second);	//!< XP[ݒ肵܂
		void setScale(const float x, const float y, const float second)
		{
			setScale(Vector2(x, y), second);
		}

		const Color& getColor() const					//!< J[擾܂
		{
			return color;
		}

		void setColor(const Color& color, const float second);	//!< J[ݒ肵܂
		//! J[ݒ肵܂
		void setColor(const float r, const float g, const float b, const float a, const float second)
		{
			setColor(Color(r, g, b, a), second);
		}

		GraphicDevice::BlendMode getBlendMode() const		//!< uh[h擾܂
		{
			return static_cast<GraphicDevice::BlendMode>(blendMode);
		}

		void setBlendMode(const GraphicDevice::BlendMode blendMode)	//!< uh[hݒ肵܂
		{
			this->blendMode = static_cast<unsigned char>(blendMode);
		}

		bool loadTexture(const std::string& filename)	//!< eNX`ǂݍ݂܂
		{
			return loadTextureCore(&texture, filename);
		}

		void unloadTexture()							//!< eNX`J܂
		{
			unloadTextureCore(&texture);
		}

		Texture* getTexture() const						//!< eNX`擾܂
		{
			return texture;
		}

		void setTexture(Texture* texture);				//!< eNX`ݒ肵܂

		void bindTexture()
		{
			if(texture)
				texture->bind();
		}

		void setTextureScroll(const Vector2& speed)	//!< eNX`XN[Xs[hݒ肵܂
		{
			textureScrollOffset.zero();
			textureScrollSpeed = speed;
		}

		void setCellAnimation(const Vector2& position, const Vector2& size, const float wait, const unsigned short count, const short loopCount);
		void setCellAnimation(const float x, const float y, const float w, const float h, const float wait, const unsigned short count, const short loopCount)
		{
			setCellAnimation(Vector2(x, y), Vector2(w, h), wait, count, loopCount);
		}
		void clearCellAnimation()						//!< AgXAj[V܂
		{
			animationCellEnable = false;
		}

		void startCellAnimation()						//!< AgXAj[VJn܂
		{
			animationCellTime = 0;
			animationCellCount = 0;
			animationCellLoopCount = animationCellLoopCountOrigin;
			animationCellRunning = true;
		}

		void stopCellAnimation()						//!< AgXAj[V~܂
		{
			animationCellRunning = false;
		}

		float getCellAnimationTime() const;

		void setCellNumber(int pattern)					//!< AgXw肵܂
		{
			if(pattern < 0)
				pattern = 0;
			/*
			else if(pattern > animationCellMaxCount)
				pattern = animationCellMaxCount;
			*/
			animationCellCount = static_cast<unsigned short>(pattern);
		}

		void setCell(const Vector2& position, const Vector2& size);
		void setCell(const float x, const float y, const Vector2& size)
		{
			setCell(Vector2(x, y), size);
		}
		void setCell(const float x, const float y, const float w, const float h)
		{
			setCell(Vector2(x, y), Vector2(w, h));
		}

		bool isRunningCellAnimation() const
		{
			return animationCellRunning;
		}

		void addAnimation(const std::string& name, CellAnimation* animation)
		{
			animations.insert(std::pair<std::string, CellAnimation*>(name, static_cast<CellAnimation*>(animation->retain())));
		}

		void removeAnimation(const std::string& name);	//!< Aj[V܂
		bool setAnimation(const std::string& name);		//!< Aj[VJn܂
		CellAnimation* getAnimation(const std::string& name);	//!< Aj[V擾܂

		void move(const Vector2& position, const float second);	//!< ړ܂
		void move(const float x, const float y, const float second)
		{
			move(Vector2(x, y), second);
		}
		void chase(const Vector2& position, const float rate);	//!< ړ܂
		void chase(const float x, const float y, const float rate)
		{
			chase(Vector2(x, y), rate);
		}
		bool arrived() const;									//!< ׂ܂

		void jump(const float height, const float second)		//!< Wv܂
		{
			jumpTime = second;
			jumpAngle = 3.1415926535897932384626433832795f * (1.0f / second);
			jumpHeight = height;
		}

		void shake(const float amplitude, const float second)	//!< U܂
		{
			shakeTime = shakeLength = second;
			shakeAmplitude = amplitude;
		}

		bool getOpaque() const;							//!< sԂ擾܂
		void setOpaque(const bool opaque);				//!< sԂݒ肵܂

		bool getClipping() const;						//!< VUOԂ擾܂
		void setClipping(const bool clippint);			//!< VUOԂݒ肵܂

		bool getTouchable() const;						//!< ^b`\Ԃ擾܂
		void setTouchable(const bool touchable);		//!< ^b`\Ԃݒ肵܂

		bool getVisible() const;						//!< \邩擾
		void setVisible(const bool visible);			//!< \邩ݒ

		bool getEnable() const;							//!< LEݒ
		void setEnable(const bool enable);				//!< L擾

		bool getHighlightFlag() const;					//!< nCCgh[tO擾
		void setHighlightFlag(const bool enable);		//!< nCCgh[tOݒ

		bool getOwnerDraw() const;						//!< I[i[h[tO擾
		void setOwnerDraw(const bool ownerDraw);		//!< I[i[h[tOݒ

		int getUserData() const;						//!< [U[f[^擾܂
		void setUserData(const int data);				//!< [U[f[^ݒ肵܂

		virtual bool isInPosition(const Vector2& localPosition) const	//!< wW܂ނۂ
		{
			return (localPosition.x >= 0) && (localPosition.y >= 0) && (localPosition.x < size.x) && (localPosition.y < size.y);
		}

		bool isInScreenPosition(const Vector2& position) const	//!< wW܂ނۂ
		{
#if 0
			const Vector2 localPosition = screenPosition - getScreenPosition();
			const Vector2& localSize = getSize();
			return (localPosition.x >= 0) && (localPosition.y >= 0) && (localPosition.x < localSize.x) && (localPosition.y < localSize.y);
#else
			return false;
#endif
		}

		void setActionEvent(ActionEvent* actionEvent)
		{
			this->actionEvent = actionEvent;
		}

		Component* setMouseCapture()								//!< }EXLv`[Ԃɂ
		{
			return setMouseCapture(this);
		}
		bool releaseMouseCapture()
		{
			return releaseMouseCapture(this);
		}
		bool isMouseCaptured() const;								//!< }EXLv`[H
		static Component* setMouseCapture(Component* component);	//!< }EXLv`[Ԃɂ
		static bool releaseMouseCapture(Component* component);		//!< }EXLv`[Ԃ
		static Component* getMouseCapture();						//!< }EXLv`[ĂR|[lg擾

		static Component* deserialize(mana_stream* stream);			//!< fVACY

		virtual void onSerialize(mana_stream* stream) const;		//!< VACYCxg
		virtual void onDeserialize(mana_stream* stream);			//!< fVACYCxg
		virtual void onDestroy(Component* component)				//!< 폜Cxg
		{
			(void)component;
		}

		virtual void onUpdate(const UpdateInfomation& updateInfomation);	//! XVCxg
		virtual void onDraw(const DrawRect& drawRect);				//!< `Cxg
		virtual bool onTouchesBegan(const Vector2& localPosition);	//!< ^b`JnCxg
		virtual bool onTouchesMoved(const Vector2& localPosition);	//!< ^b`ړCxg
		virtual bool onTouchesEnded(const Vector2& localPosition);	//!< ^b`ICxg
		virtual bool onTouchesCancelled(const Vector2& localPosition);	//!< ^b`LZCxg
		virtual bool onSize(const Vector2& size);					//!< TCYύXCxg
		virtual void onSizeChanged();								//!< TCYύXCxg

		virtual bool touchesBegan(const Vector2& localPosition);	//!< ^b`Jn
		virtual bool touchesMoved(const Vector2& localPosition);	//!< ^b`ړ
		virtual bool touchesEnded(const Vector2& localPosition);	//!< ^b`I
		virtual bool touchesCancelled(const Vector2& localPosition);//!< ^b`LZ

		virtual bool compare(const Component& component) const;
		virtual bool operator==(const Component& component) const
		{
			return compare(component);
		}

		virtual bool operator!=(const Component& component) const
		{
			return !compare(component);
		}

		static bool loadTextureCore(Texture** texture, const std::string& filename);
		static void unloadTextureCore(Texture** texture);

		static void panel(const Vector2& origin, const Vector2& size, const Color& color, const unsigned int style);
		static void clearComponentCounter()				//!< R|[lgID̃JE^[܂
		{
			componentCounter = 1;
		}

		static void clearAll();							//!< SẴR|[lgIɊJ܂
		static void dumpAll();							//!< SẴR|[lg_v܂
		static Component* find(const unsigned int identification);	//!< R|[lg܂
		static void clearLastTouchedComponentID()		//!< ŌɃ^b`ꂽR|[lgID܂
		{
			lastTouchedComponentID = 0;
		}

		static unsigned int getLastTouchedComponentID()	//!< ŌɃ^b`ꂽR|[lgID擾܂
		{
			return lastTouchedComponentID;
		}

		static bool getDebugInfomation()				//!< fobNtO擾܂
		{
			return drawDebugInfomation;
		}

		static void setDebugInfomation(const bool enable)	//!< fobNtOݒ肵܂
		{
			drawDebugInfomation = enable;
		}

		static bool isDragging()
		{
			return dragging;
		}

		// eXg
		virtual void testSerialize() const;		//!< VACYeXg
		static void allTestSerialize();			//!< VACYeXg

	protected:
		Color getDrawColor(const DrawRect& drawRect) const;
		Color getDrawColor(const DrawRect& drawRect, const Color& color) const;

	private:
		void removeFromComponents();
	};
}

#endif
