/*
 * graph2D
 * Copyright (c) 2009 Shun Moriya <shun126@users.sourceforge.jp>
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 *
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 *
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

/*!
 * @file
 * @brief	 Component Ɋւwb_[t@C
 *
 * ̃t@C͕ Component Ɋւwb_[t@CłB
 *
 * @author	Shun Moriya <shun126@users.sourceforge.jp>
 */

#if !defined(___GRAPH2D_CONTAINER_H___)
#define ___GRAPH2D_CONTAINER_H___

#include "component.h"
//#include "layout.h"

namespace Graph2D
{
	/*!
	 * @class
	 * @brief	 Component ǗNXł
	 *
	 * Component zɓo^Ǘ܂Bz̔ԍႢقǗDIɕ`悳܂B
	 */
	class Container : public Component
	{
		DISALLOW_COPY_AND_ASSIGN(Container);

		typedef Component super;

#define GRAPH2D_CONTAINER_FLAG_FRAME_TEXTURE_REPEAT_H			(0x00000001)
#define GRAPH2D_CONTAINER_FLAG_FRAME_TEXTURE_REPEAT_V			(0x00000002)
#define GRAPH2D_CONTAINER_FLAG_COLOR_AFFECTED					(0x20000000)
#define GRAPH2D_CONTAINER_FLAG_SCROLLABLE						(0x40000000)
#define GRAPH2D_CONTAINER_FLAG_PERSPECTIVE_MODE					(0x80000000)

	public:
		typedef enum Layout
		{
			LAYOUT_CENTER = 0,
			LAYOUT_NORTH,
			LAYOUT_SOUTH,
			LAYOUT_EAST,
			LAYOUT_WEST,
			LAYOUT_NORTH_EAST,
			LAYOUT_NORTH_WEST,
			LAYOUT_SOUTH_EAST,
			LAYOUT_SOUTH_WEST,
		}Layout;

	protected:
		Component** children;				//!< Component̔z
		size_t allocatedSize;				//!< mۍςݔzTCY
		size_t pageSize;					//!< mۂy[WTCY

		Texture* frameTexture[LAYOUT_SOUTH_WEST + 1];	//!< t[eNX`
		Vector2 frameTexCoord[LAYOUT_SOUTH_WEST + 1];	//!< t[eNX`UVW
		float leftFrameSize;				//!< t[TCY
		float topFrameSize;					//!< 㑤t[TCY
		float rightFrameSize;				//!< Et[TCY
		float bottomFrameSize;				//!< t[TCY

		Vector2 toucheBeganScrollOffset;	//!< ^b`JñXN[l
		Vector2 scrollOffsetLimit;			//!< XN[El
		Vector2 scrollOffset;				//!< XN[l
		Vector2 scrollTargetOffset;			//!< XN[^[Qbgl

		unsigned int flags;					//!< tO

	private:
		static Vector2 draggingVelocity;

	protected:
		virtual ~Container();

	public:
		Container();

		virtual const char* getTypeName() const
		{
			return "Container";
		}

		void allocate(const size_t count);

		Component* get(const unsigned int index) const;
		void set(const unsigned int index, Component* component);
		void swap(const unsigned int to, const unsigned int from);
		void clear();
		void compact();
		void append(Component* component);
		void remove(Component* component);
		bool find(Component* component) const;

		size_t getCount() const
		{
			return allocatedSize;
		}

		Vector2 getClientSize() const
		{
			return Vector2(size.x - (leftFrameSize + rightFrameSize), size.y - (topFrameSize + bottomFrameSize));
		}

		//! eNX`ǂݍ݂܂
		bool loadFrameTexture(const Layout direction, const std::string& filename);
		void unloadFrameTexture(const Layout direction);

		//! lt[eNX`UVW
		const Vector2& getFrameTexCoord(const Layout direction) const;
		void setFrameTexCoord(const Layout direction, const Vector2& frameTexCoord);
		void setFrameTexCoord(const Container::Layout direction, const float u, const float v);

		//! lt[eNX`TCY
		float getLeftFrameSize() const
		{
			return leftFrameSize;
		}

		void setLeftFrameSize(const float size)
		{
			leftFrameSize = size;
		}

		float getTopFrameSize() const
		{
			return topFrameSize;
		}

		void setTopFrameSize(const float size)
		{
			topFrameSize = size;
		}

		float getRightFrameSize() const
		{
			return rightFrameSize;
		}

		void setRightFrameSize(const float size)
		{
			rightFrameSize = size;
		}

		float getBottomFrameSize() const
		{
			return bottomFrameSize;
		}

		void setBottomFrameSize(const float size)
		{
			bottomFrameSize = size;
		}

		bool getPerspectiveMode() const
		{
			return (flags & GRAPH2D_CONTAINER_FLAG_PERSPECTIVE_MODE) ? true : false;
		}

		void setPerspectiveMode(const bool enable)
		{
			if(enable)
				flags |= GRAPH2D_CONTAINER_FLAG_PERSPECTIVE_MODE;
			else
				flags &= ~GRAPH2D_CONTAINER_FLAG_PERSPECTIVE_MODE;
		}

		void affecte(const bool enable)
		{
			if(enable)
				flags |= GRAPH2D_CONTAINER_FLAG_COLOR_AFFECTED;
			else
				flags &= ~GRAPH2D_CONTAINER_FLAG_COLOR_AFFECTED;
		}

		//void applyLayout(Layout* layout);

		bool getScrollable() const
		{
			return (flags & GRAPH2D_CONTAINER_FLAG_SCROLLABLE) ? true : false;
		}

		void setScrollable(const bool scrollable)
		{
			if(scrollable)
				flags |= GRAPH2D_CONTAINER_FLAG_SCROLLABLE;
			else
				flags &= ~GRAPH2D_CONTAINER_FLAG_SCROLLABLE;

			setClipping(scrollable);
		}

		const Vector2& getScrollPosition() const
		{
			return scrollOffset;
		}

		void setScrollPosition(const Vector2& localPosition, const bool immediately = true)
		{
			scrollTargetOffset = localPosition;
			correctScrollTargetOffset();
			if(immediately)
				scrollOffset = scrollTargetOffset;
		}

		void setScrollPosition(const float x, const float y, const bool immediately = true)
		{
			setScrollPosition(Vector2(x, y), immediately);
		}

		const Vector2& getScrollSize() const
		{
			return scrollOffsetLimit;
		}

		void setScrollSize(const Vector2& size)
		{
			scrollOffsetLimit = size;
		}
		void setScrollSize(const float w, const float h)
		{
			setScrollSize(Vector2(w, h));
		}

		virtual void onSerialize(mana_stream* stream) const;
		virtual void onDeserialize(mana_stream* stream);
		virtual void onUpdate(const UpdateInfomation& updateInfomation);
		virtual void onDraw(const DrawRect& drawRect);
		virtual bool onTouchesBegan(const Vector2& localPosition);
		virtual bool onTouchesEnded(const Vector2& localPosition);
		virtual bool onTouchesMoved(const Vector2& localPosition);
		virtual bool onTouchesCancelled(const Vector2& localPosition);
		virtual bool onSize(const Vector2& size);

		virtual bool touchesBegan(const Vector2& localPosition);
		virtual bool touchesMoved(const Vector2& localPosition);
		virtual bool touchesEnded(const Vector2& localPosition);
		virtual bool touchesCancelled(const Vector2& localPosition);

		virtual bool compare(const Container& other) const;

	protected:
		void drawChild(const DrawRect& drawRect, Component* component);

	private:
		void shellSort(Component** array, const unsigned int length) const;
		void drawChildren(const DrawRect& drawRect, Component** array, const unsigned int length);
		void drawFrame(const DrawRect& drawRect);
		void drawFrameParts(const Layout direction, const Vector2& v0, const Vector2& v1, const Vector2& v2, const Vector2& v3, const Color& color, const float width, const float height);
		void correctScrollTargetOffset();
	};
}

#endif
