/*
 * graph2D
 * Copyright (c) 2009 Shun Moriya <shun126@users.sourceforge.jp>
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 *
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 *
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

#include "abort.h"
#include "data.h"
#include <cstdio>
#include <cstdlib>

#if defined(TARGET_IPHONE)
#include "platform/iOS/data_impl.h"
#elif defined(TARGET_WINDOWS)
#include "platform/windows/data_impl.h"
#endif

#if GRAPH2D_LOG_DETAIL_LEVEL >= 1
#include <libmana.h>
#endif

namespace Graph2D
{
	Data::Data() : instance(NULL)
	{
	}

	Data::Data(const void* buffer, const size_t size)
	{
		instance = Implementation::Data::create(buffer, size);
#if GRAPH2D_LOG_DETAIL_LEVEL >= 1
		MANA_TRACE("Data::load: %p %dbyte(s) #%p ... %s\n", buffer, size, instance, getBuffer() ? "OK" : "NG");
#endif
	}

	Data::Data(const char* filename, const bool resource)
	{
		instance = Implementation::Data::create(std::string(filename), resource);
#if GRAPH2D_LOG_DETAIL_LEVEL >= 1
		MANA_TRACE("Data::load: %s %dbyte(s) #%p ... %s\n", filename, getSize(), instance, getBuffer() ? "OK" : "NG");
#endif
	}
	
	Data::Data(const std::string& filename, const bool resource)
	{
		instance = Implementation::Data::create(filename, resource);
#if GRAPH2D_LOG_DETAIL_LEVEL >= 1
		MANA_TRACE("Data::load: %s %dbyte(s) #%p ... %s\n", filename.c_str(), getSize(), instance, getBuffer() ? "OK" : "NG");
#endif
	}

	Data::~Data()
	{
		if(instance)
		{
#if GRAPH2D_LOG_DETAIL_LEVEL >= 1
			MANA_TRACE("Data::unload: #%p ... OK\n", instance);
#endif
			Implementation::Data::release(instance);
		}
	}

	const void* Data::getBuffer() const
	{
		return Implementation::Data::getBuffer(instance);
	}

	size_t Data::getSize() const
	{
		return Implementation::Data::getSize(instance);
	}

	bool Data::valid() const
	{
		return getBuffer() && getSize() > 0;
	}

	bool Data::write(const std::string& filename)
	{
		return Implementation::Data::write(instance, filename);
#if 0
//abort(ERROR_CODE_FILE_WRITE_FAILED, filename.c_str());
		/*
#if __STDC_WANT_SECURE_LIB__
		FILE* file;
		if(fopen_s(&file, filename.c_str(), "wb") != 0)
			abort(ERROR_CODE_FILE_OPEN_FAILED, filename.c_str());
#else
		FILE* file = fopen(filename.c_str(), "wb");
		if(file == NULL)
			abort(ERROR_CODE_FILE_OPEN_FAILED, filename.c_str());
#endif
		if(fwrite(buffer, 1, length, file) != length)
		{
			fclose(file);
			abort(ERROR_CODE_FILE_WRITE_FAILED, filename.c_str());
		}

		fclose(file);
		*/
#endif

		return true;
	}

	bool Data::exist(const std::string& filename, const bool resource)
	{
		return Implementation::Data::exist(filename, resource);;
	}
}
