/*
 * graph2D
 * Copyright (c) 2009 Shun Moriya <shun126@users.sourceforge.jp>
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 *
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 *
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

#include "desktop.h"
#include "dialog.h"
#include <cstring>
#include <string>

namespace Graph2D
{
	Dialog::Dialog()
	{
		type = TYPE_DIALOG;
		selected = -1;
		setSize(Desktop::getInstance().getSize() * 0.33333333f);
	}

	/*!
	 * @param[in]	s		開始ポインタ
	 * @param[in]	e		終了ポインタ
	 * @param[in]	index	インデックス番号
	 */
	void Dialog::add(const char* s, const char* e, const int index)
	{
		size_t length = (size_t)(e - s);

		char* text = static_cast<char*>(alloca(length + 1));
		memcpy(text, s, length);
		text[length] = '\0';
		addContents(std::string(text), index);
	}

	/*!
	 * @param[in]	message		ダイアログ表示メッセージ。改行ごとに１選択文になります。
	 * @retval		true		成功
	 * @retval		false		失敗
	 */
	bool Dialog::initialize(const std::string& message)
	{
		clear();

		int index = 0;
		char* s = const_cast<char*>(message.c_str());
		char* e = s;

		while(*e != '\0')
		{
			if(*e == '\n')
			{
				add(s, e, index);

				index++;
				e++;
				s = e;
			}
			else
			{
				e++;
			}
		}

		add(s, e, index);

		// デスクトップの中心に設定(仮)
		const Vector2 center = (Desktop::getInstance().getSize() * 0.5f) - (size * 0.5f);
		setPosition(center);

		selected = -1;

		return true;
	}

	bool Dialog::compare(const Dialog& other) const
	{
		if(!super::compare(other))
			return false;

		if(selected != other.selected)
			return false;

		return true;
	}
}
