/*
 * graph2D
 * Copyright (c) 2011 Shun Moriya <shun126@users.sourceforge.jp>
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 *
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 *
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

#if !defined(___GRAPH2D_HEAP_H___)
#define ___GRAPH2D_HEAP_H___

#include "allocator.h"

namespace Graph2D
{
	extern Allocator global_heap;

#if !defined(NDEBUG)
	inline void* malloc(int size, const char* comment = __FILE__ __GRAPH2D_ALLOCATOR_MACRO_XSTR(__LINE__))
	{
		return global_heap.malloc(size, comment);
	}
	inline void* calloc(int count, int size, const char* comment = __FILE__ __GRAPH2D_ALLOCATOR_MACRO_XSTR(__LINE__))
	{
		return global_heap.calloc(count, size, comment);
	}
	inline void* realloc(void* pointer, int size, const char* comment = __FILE__ __GRAPH2D_ALLOCATOR_MACRO_XSTR(__LINE__))
	{
		return global_heap.realloc(pointer, size, comment);
	}
	inline void* memalign(int alignment, int size, const char* comment = __FILE__ __GRAPH2D_ALLOCATOR_MACRO_XSTR(__LINE__))
	{
		return global_heap.memalign(alignment, size, comment);
	}
#else
	inline void* malloc(int size)
	{
		return global_heap.malloc(size);
	}
	inline void* calloc(int count, int size)
	{
		return global_heap.calloc(count, size);
	}
	inline void* realloc(void* pointer, int size)
	{
		return global_heap.realloc(pointer, size);
	}
	inline void* memalign(int alignment, int size)
	{
		return global_heap.memalign(alignment, size);
	}
#endif
	inline void free(void* buffer)
	{
		global_heap.free(buffer);
	}
}

#define g2d_initialize(a, b)	Graph2D::global_heap.initialize(a, b)
#define g2d_finalize()			Graph2D::global_heap.finalize()
#define g2d_free(a)				Graph2D::global_heap.free(a)
#define g2d_malloc(a)			Graph2D::global_heap.malloc(a _GRAPH2D_ALLOCATOR_COMMENT_)
#define g2d_memalign(a, b)		Graph2D::global_heap.memalign(a, b _GRAPH2D_ALLOCATOR_COMMENT_)
#define g2d_calloc(a, b)		Graph2D::global_heap.calloc(a, b _GRAPH2D_ALLOCATOR_COMMENT_)
#define g2d_realloc(a, b)		Graph2D::global_heap.realloc(a, b _GRAPH2D_ALLOCATOR_COMMENT_)

#endif
