
/*
 * graph2D
 * Copyright (c) 2011 Shun Moriya <shun126@users.sourceforge.jp>
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 *
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 *
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

#include "messageWindow.h"

namespace Graph2D
{
	MessageWindow::MessageWindow()
	{
		type = TYPE_MESSAGE_WINDOW;

		allocate(1);

		message = new Message();
		set(0, message);
		
		setSize(480.0f, 96.0f);
		setColor(0.2f, 0.2f, 1.0f, 1.0f, 0.0f);
		setFrameStyle(FRAME_STYLE_NORMAL);

		compact();
	}

	MessageWindow::~MessageWindow()
	{
		clear();

		message->release();
	}

	void MessageWindow::clear()
	{
		message->clear();
	}

	const std::string& MessageWindow::getString() const
	{
		return message->getString();
	}

	void MessageWindow::setString(const std::string& text)
	{
		message->setString(text);
	}

	void MessageWindow::replace(const char* key, const char* word)
	{
		message->replace(key, word);
	}

	Message* MessageWindow::getMessage()
	{
		return message;
	}

	const Message* MessageWindow::getMessage() const
	{
		return getMessage();
	}

	void MessageWindow::format(const char* format, ...)
	{
		va_list ap;
		va_start(ap, format);
		message->vformat(format, ap);
		va_end(ap);
	}
	
	void MessageWindow::vformat(const char* format, va_list ap)
	{
		message->vformat(format, ap);
	}

	const Color& MessageWindow::getTextColor() const
	{
		return message->getTextColor();
	}

	void MessageWindow::setTextColor(const Color& color)
	{
		message->setTextColor(color);
	}

	void MessageWindow::setTextColor(const float r, const float g, const float b, const float a)
	{
		setTextColor(Color(r, g, b, a));
	}

	float MessageWindow::getTimer() const
	{
		return message->getTimer();
	}

	void MessageWindow::setTimer(const float timer)
	{
		message->setTimer(timer);
	}

	float MessageWindow::getDelayTimer() const
	{
		return message->getDelayTimer();
	}

	void MessageWindow::setDelayTimer(const float delayTimer)
	{
		message->setDelayTimer(delayTimer);
	}

	bool MessageWindow::finished() const
	{
		return message->finished();
	}

	void MessageWindow::onSizeChanged()
	{
		if(message)
		{
			message->setPosition(0, 0);
			message->setSize(getClientSize());
		}
	}
}
