/*
 * graph2D
 * Copyright (c) 2009 Shun Moriya <shun126@users.sourceforge.jp>
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 *
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 *
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

#import "../../graphicDevice.h"
#import <UIKit/UIKit.h>
#import <OpenGLES/EAGL.h>
#import <OpenGLES/EAGLDrawable.h>
#import <OpenGLES/ES1/gl.h>
#import <OpenGLES/ES1/glext.h>
#import <QuartzCore/QuartzCore.h>

@interface DesktopView : UIView
{
	UIWindow* window;

	EAGLContext* context;

	GLuint viewRenderbuffer;
	GLuint viewFramebuffer;
	GLuint depthRenderbuffer;

	NSTimer *animationTimer;
	NSTimeInterval animationInterval;
}
@property (nonatomic, retain) EAGLContext* context;
@property (nonatomic, assign) NSTimer* animationTimer;
@property (readonly) NSTimeInterval animationInterval;

-(id)init;
-(id)initWithFrame:(CGRect)aRect scale:(float)contentScaleFactor;
-(void)dealloc;
@end

@interface DesktopView(Singleton)
+(DesktopView*)setup:(CGRect)aRect scale:(float)contentScaleFactor;
-(void)finalize;
+(DesktopView*)instance;
+(id)allocWithZone:(NSZone*)zone;
-(id)copyWithZone:(NSZone*)zone;
-(id)retain;
-(unsigned)returnCount;
-(void)release;
-(id)autorelease;
@end

@interface DesktopView(Window)
-(void)attachInWindow:(UIWindow*)window;
-(void)attach;
-(void)dettach;
@end

@interface DesktopView(Animation)
-(void)startAnimation;
-(void)stopAnimation;
-(void)setAnimationTimer:(NSTimer*)newTimer;
- (void)setAnimationInterval:(NSTimeInterval)interval;
@end

@interface DesktopView(Mouse)
-(void)touchesBegan:(NSSet*)touches withEvent:(UIEvent*)event;
-(void)touchesEnded:(NSSet*)touches withEvent:(UIEvent*)event;
-(void)touchesMoved:(NSSet*)touches withEvent:(UIEvent*)event;
-(void)touchesCancelled:(NSSet*)touches withEvent:(UIEvent*)event;
@end
