/*
 * graph2D
 * Copyright (c) 2009 Shun Moriya <shun126@users.sourceforge.jp>
 * 
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 * 
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 * 
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 * 
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 * 
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

native void loadImage(string filename);
native void fade(float r, float g, float b, float a, float second);

native int create(float x, float y, float w, float h);
/*
コールバックのしかけが必要？
native int createComponent(float x, float y, float w, float h);
native int createContainer(float x, float y, float w, float h);
native int createButton(float x, float y, float w, float h. string label);
*/
native void destroy(int id);
native void touchable(int id, int enable);

native void changeScene(int type);
native void swapScene();
native int getScene();

native void setLayer(int parent, int layer, int id);
native void swapLayer(int parent, int to, int from);
native void releaseLayer(int parent, int layer);

native void setPosition(int id, float x, float y);
native void setSize(int id, float w, float h);
native void setScale(int id, float x, float y, float second);
native void setColor(int id, float r, float g, float b, float a, float second);

native void loadTexture(int id, string filename);
native void setTextureScroll(int id, float x, float y);

native void loadScript(int id, string filename);

native void setCellAnimation(int id, float x, float y, float width, float height, float wait, int count, int loopCount);
native void startCellAnimation(int id);
native void stopCellAnimation(int id);
native void setCellNumber(int id, int pattern);

native void addAnimation(int id, string name, float x, float y, float w, float h, float wait, int count, int loopCount);
native void removeAnimation(int id, string name);
native void setAnimation(int id, string name);
native void waitAnimation(int id);

native void move(int id, float x, float y, float time);
native void moveFinish(int id);

native void jump(int id, float time, float height);
native void shake(int id, float time, float amplitude);

native void openMessageWindow();
native void closeMessageWindow();
native void showMessage(string text);
native void setMessage(string text);
native void waitMessage();
native void setMessageColor(float r, float g, float b, float a);

/*!
 * @brief		メッセージ表示後の待機時間を設定します
 * @param[in]	delayTimer	0ならタッチを待ちます。正の値なら指定秒数後閉じます。負の値ならば表示したままです。
 */
native void setMessageDelayTimer(float delayTimer);

native int select(string text);
native int touch();
native int checkTouch(int initial);

// audio
native int talk(string filename);
native int playMusic(string filename, float volume, float time);
native void stopMusic(int id, float volume, float time);
native void setMusicVolume(int id, float volume, float time);

// sound
native int loadSound(string filename);
native void releaseSound(int id);
native void playSound(int id);
